/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.RemoveFunction;

public class RemoveFunctionTest {
    private RemoveFunction removeFunction;

    @Before
    public void setUp() {
        this.removeFunction = new RemoveFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.removeFunction.invoke((List)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(null, BigDecimal.ONE), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(Collections.emptyList(), null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionZero() {
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.ZERO), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionOutOfListBounds() {
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.valueOf(2L)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.valueOf(154L)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.valueOf(-2L)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.valueOf(-154L)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokePositionPositive() {
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.ONE), Collections.emptyList());
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(14L)), BigDecimal.ONE), Arrays.asList("test", BigDecimal.valueOf(14L)));
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(14L)), BigDecimal.valueOf(2L)), Arrays.asList(1, BigDecimal.valueOf(14L)));
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(14L)), BigDecimal.valueOf(3L)), Arrays.asList(1, "test"));
    }

    @Test
    public void invokePositionNegative() {
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Collections.singletonList(1), BigDecimal.valueOf(-1L)), Collections.emptyList());
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(14L)), BigDecimal.valueOf(-1L)), Arrays.asList(1, "test"));
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(14L)), BigDecimal.valueOf(-2L)), Arrays.asList(1, BigDecimal.valueOf(14L)));
        FunctionTestUtil.assertResultList(this.removeFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(14L)), BigDecimal.valueOf(-3L)), Arrays.asList("test", BigDecimal.valueOf(14L)));
    }
}

