/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.jpmml;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNInvokingjPMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNInvokingjPMMLTest.class);

    @Test
    public void testInvokeIris() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        this.checkInvokeIris(runtime, dmnModel, emptyContext);
    }

    private void checkInvokeIris(DMNRuntime runtime, DMNModel dmnModel, DMNContext emptyContext) {
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Decision"), (Matcher)CoreMatchers.is((Object)"Iris-versicolor"));
    }

    @Test
    public void testInvokeIris_in1_wrong() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris_in1.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("in1", (Object)99);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertTrue((boolean)dmnResult.getMessages().stream().anyMatch(m -> m.getSourceId().equals("in1")));
    }

    @Test
    public void testInvokeIris_in1_ok() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris_in1.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("in1", (Object)4.3);
        this.checkInvokeIris(runtime, dmnModel, context);
    }

    @Test
    public void testDummyInteger() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"dummy_integer.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"dummy_integer.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_d9065b95-bc37-41dc-8566-8191af7b7867", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("hardcoded"), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
    }

    @Test
    public void testMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"invoke_iris_KNN.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris_KNN.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_a76cdc83-83b1-4f9c-8cf8-5a0179e776d5", "Drawing 1");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Map resultOfHardcoded = (Map)result.get("hardcoded");
        Assert.assertThat((Object)resultOfHardcoded.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
        Assert.assertThat((Object)resultOfHardcoded, (Matcher)Matchers.hasEntry((Object)"Predicted_Species", (Object)"virginica"));
        Assert.assertThat((Object)resultOfHardcoded, (Matcher)Matchers.hasKey((Object)"Predicted_Petal.Width"));
        Assert.assertThat((Object)((BigDecimal)resultOfHardcoded.get("Predicted_Petal.Width")), (Matcher)CoreMatchers.is((Matcher)Matchers.closeTo((BigDecimal)new BigDecimal("1.9333333333333336"), (BigDecimal)new BigDecimal("0.1"))));
    }
}

