/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.jpmml;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.pmml.DMNImportPMMLInfo;
import org.kie.dmn.core.pmml.DMNPMMLModelInfo;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNInvokingjPMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNInvokingjPMMLTest.class);

    @Test
    public void testInvokeIris() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        this.checkInvokeIris(runtime, dmnModel, emptyContext);
    }

    private void checkInvokeIris(DMNRuntime runtime, DMNModel dmnModel, DMNContext emptyContext) {
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Decision")).isEqualTo((Object)"Iris-versicolor");
    }

    @Test
    public void testInvokeIris_in1_wrong() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris_in1.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("in1", (Object)99);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((List)dmnResult.getMessages()).anyMatch(m -> m.getSourceId().equals("in1"));
    }

    @Test
    public void testInvokeIris_in1_ok() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Invoke Iris_in1.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris model.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_91c67ae0-5753-4a23-ac34-1b558a006efd", "http://www.dmg.org/PMML-4_1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("in1", (Object)4.3);
        this.checkInvokeIris(runtime, dmnModel, context);
    }

    @Test
    public void testDummyInteger() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"dummy_integer.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"dummy_integer.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_d9065b95-bc37-41dc-8566-8191af7b7867", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("hardcoded")).isEqualTo((Object)new BigDecimal(3));
    }

    @Test
    public void testMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"invoke_iris_KNN.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris_KNN.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_a76cdc83-83b1-4f9c-8cf8-5a0179e776d5", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Map resultOfHardcoded = (Map)result.get("hardcoded");
        Assertions.assertThat((Map)resultOfHardcoded).hasSizeGreaterThan(1);
        Assertions.assertThat((Map)resultOfHardcoded).containsEntry((Object)"Predicted_Species", (Object)"virginica");
        Assertions.assertThat((Map)resultOfHardcoded).containsKey((Object)"Predicted_Petal.Width");
        Assertions.assertThat((BigDecimal)((BigDecimal)resultOfHardcoded.get("Predicted_Petal.Width"))).isCloseTo(new BigDecimal("1.9333333333333336"), Offset.offset((Number)new BigDecimal("0.1")));
        Map pmmlImportInfo = ((DMNModelImpl)dmnModel).getPmmlImportInfo();
        Assertions.assertThat((Map)pmmlImportInfo).hasSize(1);
        DMNImportPMMLInfo p0 = (DMNImportPMMLInfo)pmmlImportInfo.values().iterator().next();
        Assertions.assertThat((String)p0.getImportName()).isEqualTo("test20190907");
        Assertions.assertThat((Collection)p0.getModels()).hasSize(1);
        DMNPMMLModelInfo m0 = (DMNPMMLModelInfo)p0.getModels().iterator().next();
        Assertions.assertThat((String)m0.getName()).isEqualTo("kNN_model");
        Map outputFields = m0.getOutputFields();
        CompositeTypeImpl output = (CompositeTypeImpl)outputFields.get("kNN_model");
        Assertions.assertThat((String)"test20190907").isEqualTo(output.getNamespace());
        Map fields = output.getFields();
        SimpleTypeImpl out1 = (SimpleTypeImpl)fields.get("Predicted_Species");
        Assertions.assertThat((String)"test20190907").isEqualTo(out1.getNamespace());
        Assertions.assertThat((Comparable)BuiltInType.STRING).isEqualTo((Object)out1.getFeelType());
        SimpleTypeImpl out2 = (SimpleTypeImpl)fields.get("Predicted_Petal.Width");
        Assertions.assertThat((String)"test20190907").isEqualTo(out2.getNamespace());
        Assertions.assertThat((Comparable)BuiltInType.NUMBER).isEqualTo((Object)out2.getFeelType());
        SimpleTypeImpl out3 = (SimpleTypeImpl)fields.get("neighbor1");
        Assertions.assertThat((String)"test20190907").isEqualTo(out3.getNamespace());
        Assertions.assertThat((Comparable)BuiltInType.STRING).isEqualTo((Object)out3.getFeelType());
        SimpleTypeImpl out4 = (SimpleTypeImpl)fields.get("neighbor2");
        Assertions.assertThat((String)"test20190907").isEqualTo(out4.getNamespace());
        Assertions.assertThat((Comparable)BuiltInType.STRING).isEqualTo((Object)out4.getFeelType());
        SimpleTypeImpl out5 = (SimpleTypeImpl)fields.get("neighbor3");
        Assertions.assertThat((String)"test20190907").isEqualTo(out5.getNamespace());
        Assertions.assertThat((Comparable)BuiltInType.STRING).isEqualTo((Object)out5.getFeelType());
    }

    @Test
    public void testMultipleOutputsNoModelName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"invoke_iris_KNN_noModelName.dmn", DMNInvokingjPMMLTest.class, (String[])new String[]{"iris_KNN_noModelName.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_a76cdc83-83b1-4f9c-8cf8-5a0179e776d5", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Map resultOfHardcoded = (Map)result.get("hardcoded");
        Assertions.assertThat((int)resultOfHardcoded.size()).isGreaterThan(1);
        Assertions.assertThat((Map)resultOfHardcoded).containsEntry((Object)"Predicted_Species", (Object)"virginica");
        Assertions.assertThat((Map)resultOfHardcoded).containsKey((Object)"Predicted_Petal.Width");
        Assertions.assertThat((BigDecimal)((BigDecimal)resultOfHardcoded.get("Predicted_Petal.Width"))).isCloseTo(new BigDecimal("1.9333333333333336"), Offset.offset((Number)new BigDecimal("0.1")));
        Map pmmlImportInfo = ((DMNModelImpl)dmnModel).getPmmlImportInfo();
        Assertions.assertThat(pmmlImportInfo.keySet()).hasSize(1);
        DMNImportPMMLInfo p0 = (DMNImportPMMLInfo)pmmlImportInfo.values().iterator().next();
        Assertions.assertThat((String)p0.getImportName()).isEqualTo("test20190907");
        Assertions.assertThat((Collection)p0.getModels()).hasSize(1);
        DMNPMMLModelInfo m0 = (DMNPMMLModelInfo)p0.getModels().iterator().next();
        Assertions.assertThat((String)m0.getName()).isNull();
        Map outputFields = m0.getOutputFields();
        SimpleTypeImpl out1 = (SimpleTypeImpl)outputFields.get("Predicted_Species");
        Assertions.assertThat((Comparable)BuiltInType.UNKNOWN).isEqualTo((Object)out1.getFeelType());
        SimpleTypeImpl out2 = (SimpleTypeImpl)outputFields.get("Predicted_Petal.Width");
        Assertions.assertThat((Comparable)BuiltInType.UNKNOWN).isEqualTo((Object)out2.getFeelType());
        SimpleTypeImpl out3 = (SimpleTypeImpl)outputFields.get("neighbor1");
        Assertions.assertThat((Comparable)BuiltInType.UNKNOWN).isEqualTo((Object)out3.getFeelType());
        SimpleTypeImpl out4 = (SimpleTypeImpl)outputFields.get("neighbor2");
        Assertions.assertThat((Comparable)BuiltInType.UNKNOWN).isEqualTo((Object)out4.getFeelType());
        SimpleTypeImpl out5 = (SimpleTypeImpl)outputFields.get("neighbor3");
        Assertions.assertThat((Comparable)BuiltInType.UNKNOWN).isEqualTo((Object)out5.getFeelType());
    }
}

