/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1.imports;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DMNTestUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(ImportsTest.class);

    public ImportsTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testImportDependenciesForDTInAContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Imported_Model.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Import_BKM_and_have_a_Decision_Ctx_with_DT.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/definitions/_f27bb64b-6fc7-4e1f-9848-11ba35e0df36", "Imported Model");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c3e08836-7973-4e4d-af2b-d46b23725c13", "Import BKM and have a Decision Ctx with DT");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("A Person", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"John"), DynamicTypeUtils.entry((Object)"age", (Object)47)}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("A Decision Ctx with DT").getResult(), (Matcher)CoreMatchers.is((Object)"Respectfully, Hello John!"));
    }

    @Test
    public void testImport2BKMs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Do_say_hello_with_2_bkms.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Saying_hello_2_bkms.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_01a65215-7e0d-47ac-845a-a768f6abf7fe", "Do say hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Person name", (Object)"John");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Say hello decision").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("what about hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello"));
    }

    @Test
    public void testImport2BKMsInvoke() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Do_invoke_hello_with_2_bkms.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Saying_hello_2_bkms.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_eedf6ecc-f113-4333-ace0-79b783e313e5", "Do invoke hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = runtime.newContext();
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("invocation of hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
    }

    @Test
    public void testImport2BKMsInvokeUsingInputData() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Do_invoke_hello_with_2_bkms_using_inputdata.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Saying_hello_2_bkms.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_eedf6ecc-f113-4333-ace0-79b783e313e5", "Do invoke hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Person name", (Object)"Bob");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("what about hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, Bob"));
    }

    @Test
    public void testImport3Levels() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"L3_Do_say_hello.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Do_say_hello_with_2_bkms.dmn", "Saying_hello_2_bkms.dmn"});
        if (LOG.isDebugEnabled()) {
            runtime.addListener(DMNRuntimeUtil.createListener());
        }
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_01a65215-7e0d-47ac-845a-a768f6abf7fe", "Do say hello with 2 bkms");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModelL3 = runtime.getModel("http://www.trisotech.com/dmn/definitions/_820c548c-377d-463e-a62b-bb95ddc4758c", "L3 Do say hello");
        Assert.assertThat((Object)dmnModelL3, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModelL3.getMessages()), (Object)dmnModelL3.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Another Name", (Object)"Bob");
        context.set("L2import", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"John")}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModelL3, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("L3 decision").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, Bob"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("L3 view on M2").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("L3 what about hello").getResult(), (Matcher)CoreMatchers.is((Object)"Hello"));
    }

    @Test
    public void testImportHardcodedDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Spell_Greeting.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Import_Spell_Greeting.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_88f4fc88-1eb2-4188-a721-5720cf5565ce", "Spell Greeting");
        Assert.assertThat((Object)importedModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), (Object)importedModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_d67f19e9-7835-4cad-9c80-16b8423cc392", "Import Spell Greeting");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = runtime.newContext();
        context.set("Person Name", (Object)"John");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Say the Greeting to Person").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
    }

    @Test
    public void testImportTransitiveBaseModel() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9", (String)"Say hello 1ID1D");
    }

    @Test
    public void testImportTransitiveEvaluate2Layers() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        DMNContext context = runtime.newContext();
        context.set("modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"John")}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Evaluating Say Hello").getResult(), (Matcher)CoreMatchers.is((Object)"Evaluating Say Hello to: Hello, John"));
    }

    @Test
    public void testImportTransitiveEvaluate3Layers() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_10435dcd-8774-4575-a338-49dd554a0928", (String)"Model C");
        DMNContext context = runtime.newContext();
        context.set("Model B", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"B.A.John")}))}));
        context.set("Model B2", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"B2.A.John2")}))}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Model C Decision based on Bs").getResult(), (Matcher)CoreMatchers.is((Object)"B: Evaluating Say Hello to: Hello, B.A.John; B2:Evaluating Say Hello to: Hello, B2.A.John2"));
    }

    @Test
    public void testImportingID() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Importing_ID.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_24bac498-2a5a-403d-8b44-d407628784c4", (String)"Importing ID");
        DMNContext context = runtime.newContext();
        context.set("my import hello", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"DROOLS-2944")}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)evaluateAll);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Hello decision using imported InputData").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, DROOLS-2944"));
    }

    @Test
    public void testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        this.testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions_evaluateResultsAndCheck(runtime, context -> runtime.evaluateByName(dmnModel, context, new String[]{"modelA.Greet the Person", "Evaluating Say Hello"}));
        this.testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions_evaluateResultsAndCheck(runtime, context -> runtime.evaluateById(dmnModel, context, new String[]{"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9#_f7fdaec4-d669-4797-b3b4-12b860de2eb5", "_96df766e-23e1-4aa6-9d5d-545fbe2f1e23"}));
    }

    private void testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions_evaluateResultsAndCheck(DMNRuntime runtime, Function<DMNContext, DMNResult> fn) {
        DMNContext context = runtime.newContext();
        context.set("modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"John")}));
        DMNResult evaluateAll = fn.apply(context);
        LOG.debug("{}", (Object)evaluateAll);
        LOG.debug("{}", (Object)evaluateAll.getDecisionResults());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), (Object)evaluateAll.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("Evaluating Say Hello").getResult(), (Matcher)CoreMatchers.is((Object)"Evaluating Say Hello to: Hello, John"));
        Assert.assertThat((Object)evaluateAll.getDecisionResultByName("modelA.Greet the Person").getResult(), (Matcher)CoreMatchers.is((Object)"Hello, John"));
    }

    @Test
    public void testRetrieveDecisionByIDName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        Assert.assertThat((Object)dmnModel.getDecisionById("_96df766e-23e1-4aa6-9d5d-545fbe2f1e23").getName(), (Matcher)CoreMatchers.is((Object)"Evaluating Say Hello"));
        Assert.assertThat((Object)dmnModel.getDecisionById("http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9#_f7fdaec4-d669-4797-b3b4-12b860de2eb5").getName(), (Matcher)CoreMatchers.is((Object)"Greet the Person"));
        Assert.assertThat((Object)dmnModel.getDecisionById("_f7fdaec4-d669-4797-b3b4-12b860de2eb5"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)dmnModel.getDecisionByName("Evaluating Say Hello").getId(), (Matcher)CoreMatchers.is((Object)"_96df766e-23e1-4aa6-9d5d-545fbe2f1e23"));
        Assert.assertThat((Object)dmnModel.getDecisionByName("Greet the Person"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)dmnModel.getDecisionByName("modelA.Greet the Person").getId(), (Matcher)CoreMatchers.is((Object)"_f7fdaec4-d669-4797-b3b4-12b860de2eb5"));
        Assert.assertThat((Object)dmnModel.getInputById("http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9#_4f6c136c-8512-4d71-8bbf-7c9eb6e74063").getName(), (Matcher)CoreMatchers.is((Object)"Person name"));
        Assert.assertThat((Object)dmnModel.getInputById("_4f6c136c-8512-4d71-8bbf-7c9eb6e74063"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)dmnModel.getInputByName("Person name"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)dmnModel.getInputByName("modelA.Person name").getId(), (Matcher)CoreMatchers.is((Object)"_4f6c136c-8512-4d71-8bbf-7c9eb6e74063"));
    }

    @Test
    public void testImportChain() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNModelImpl modelA = (DMNModelImpl)DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9", (String)"Say hello 1ID1D");
        Assert.assertThat(modelA.getImportChainAliases().entrySet(), (Matcher)Matchers.hasSize((int)0));
        DMNModelImpl modelB = (DMNModelImpl)DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        Assert.assertThat(modelB.getImportChainAliases().entrySet(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)modelB.getImportChainAliases(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9"), (Matcher)Matchers.contains((Object[])new List[]{Collections.singletonList("modelA")})));
        DMNModelImpl modelC = (DMNModelImpl)DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_10435dcd-8774-4575-a338-49dd554a0928", (String)"Model C");
        Assert.assertThat(modelC.getImportChainAliases().entrySet(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)modelC.getImportChainAliases(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c"), (Matcher)Matchers.contains((Object[])new List[]{Collections.singletonList("Model B")})));
        Assert.assertThat((Object)modelC.getImportChainAliases(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"http://www.trisotech.com/definitions/_9d46ece4-a96c-4cb0-abc0-0ca121ac3768"), (Matcher)Matchers.contains((Object[])new List[]{Collections.singletonList("Model B2")})));
        Assert.assertThat((Object)modelC.getImportChainAliases(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9"), (Matcher)Matchers.containsInAnyOrder((Object[])new List[]{Arrays.asList("Model B2", "modelA"), Arrays.asList("Model B", "modelA")})));
    }
}

