/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;

public class FlightRebookingTest
extends BaseDMN1_1VariantTest {
    public FlightRebookingTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testSolution1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0019-flight-rebooking.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn", "0019-flight-rebooking");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        List passengerList = this.loadPassengerList();
        List flightList = this.loadFlightList();
        context.set("Passenger List", (Object)passengerList);
        context.set("Flight List", (Object)flightList);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Rebooked Passengers"), (Matcher)CoreMatchers.is((Object)this.loadExpectedResult()));
    }

    @Test
    public void testSolutionAlternate() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0019-flight-rebooking-alternative.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn", "0019-flight-rebooking");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        List passengerList = this.loadPassengerList();
        List flightList = this.loadFlightList();
        context.set("Passenger List", (Object)passengerList);
        context.set("Flight List", (Object)flightList);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Rebooked Passengers"), (Matcher)CoreMatchers.is((Object)this.loadExpectedResult()));
    }

    @Test
    public void testSolutionSingletonLists() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0019-flight-rebooking-singleton-lists.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn", "0019-flight-rebooking");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        List passengerList = this.loadPassengerList();
        List flightList = this.loadFlightList();
        context.set("Passenger List", (Object)passengerList);
        context.set("Flight List", (Object)flightList);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Rebooked Passengers"), (Matcher)CoreMatchers.is((Object)this.loadExpectedResult()));
    }

    @Test
    public void testSolutionBadExample() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0019-flight-rebooking-bad-example.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn", "0019-flight-rebooking");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        List passengerList = this.loadPassengerList();
        List flightList = this.loadFlightList();
        context.set("Passenger List", (Object)passengerList);
        context.set("Flight List", (Object)flightList);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Rebooked Passengers"), (Matcher)CoreMatchers.is((Object)this.loadExpectedResult()));
    }

    @Test
    public void testUninterpreted() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0019-flight-rebooking-uninterpreted.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_188d6caf-a355-49b5-a692-bd6ce713da08", "0019-flight-rebooking");
        runtime.addListener(DMNRuntimeUtil.createListener());
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        List passengerList = this.loadPassengerList();
        List flightList = this.loadFlightList();
        context.set("Passenger List", (Object)passengerList);
        context.set("Flight List", (Object)flightList);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Rebooked Passengers").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.SKIPPED));
    }

    private List loadPassengerList() {
        Object[][] passengerData = new Object[][]{{"Tom", "bronze", 10, "UA123"}, {"Igor", "gold", 50000, "UA123"}, {"Jenny", "gold", 500000, "UA123"}, {"Harry", "gold", 100000, "UA123"}, {"Dick", "silver", 100, "UA123"}};
        ArrayList passengerList = new ArrayList();
        for (Object[] pd : passengerData) {
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("Name", pd[0]);
            p.put("Status", pd[1]);
            p.put("Miles", this.number((Number)pd[2]));
            p.put("Flight Number", pd[3]);
            passengerList.add(p);
        }
        return passengerList;
    }

    private List loadFlightList() {
        Object[][] flightData = new Object[][]{{"UA123", "SFO", "SNA", this.date("2017-01-01T18:00:00"), this.date("2017-01-01T19:00:00"), 5, "cancelled"}, {"UA456", "SFO", "SNA", this.date("2017-01-01T19:00:00"), this.date("2017-01-01T20:00:00"), 2, "scheduled"}, {"UA789", "SFO", "SNA", this.date("2017-01-01T21:00:00"), this.date("2017-01-01T23:00:00"), 2, "scheduled"}, {"UA1001", "SFO", "SNA", this.date("2017-01-01T23:00:00"), this.date("2017-01-02T05:00:00"), 0, "scheduled"}, {"UA1111", "SFO", "LAX", this.date("2017-01-01T23:00:00"), this.date("2017-01-02T05:00:00"), 2, "scheduled"}};
        ArrayList flightList = new ArrayList();
        for (Object[] pd : flightData) {
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("Flight Number", pd[0]);
            p.put("From", pd[1]);
            p.put("To", pd[2]);
            p.put("Departure", pd[3]);
            p.put("Arrival", pd[4]);
            p.put("Capacity", pd[5]);
            p.put("Status", pd[6]);
            flightList.add(p);
        }
        return flightList;
    }

    private List loadExpectedResult() {
        Object[][] passengerData = new Object[][]{{"Jenny", "gold", 500000, "UA456"}, {"Harry", "gold", 100000, "UA456"}, {"Igor", "gold", 50000, "UA789"}, {"Dick", "silver", 100, "UA789"}, {"Tom", "bronze", 10, null}};
        ArrayList passengerList = new ArrayList();
        for (Object[] pd : passengerData) {
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("Name", pd[0]);
            p.put("Status", pd[1]);
            p.put("Miles", this.number((Number)pd[2]));
            p.put("Flight Number", pd[3]);
            passengerList.add(p);
        }
        return passengerList;
    }

    private LocalDateTime date(String date) {
        return LocalDateTime.parse(date);
    }

    private BigDecimal number(Number n) {
        return BigDecimal.valueOf(n.longValue());
    }
}

