/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.validation.v1_1;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorBusinessKnowledgeModelTest
extends AbstractValidatorTest {
    @Test
    public void testBKM_MISSING_VAR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("businessknowledgemodel/BKM_MISSING_VAR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
        }
    }

    @Test
    public void testBKM_MISSING_VAR_FileInput() {
        List validate = validator.validate(this.getFile("businessknowledgemodel/BKM_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testBKM_MISSING_VAR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("businessknowledgemodel/BKM_MISSING_VAR.dmn", "https://github.com/kiegroup/kie-dmn", "BKM_MISSING_VAR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testBKM_MISMATCH_VAR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("businessknowledgemodel/BKM_MISMATCH_VAR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
        }
    }

    @Test
    public void testBKM_MISMATCH_VAR_FileInput() {
        List validate = validator.validate(this.getFile("businessknowledgemodel/BKM_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testBKM_MISMATCH_VAR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("businessknowledgemodel/BKM_MISMATCH_VAR.dmn", "https://github.com/kiegroup/kie-dmn", "BKM_MISSING_VAR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testBKM_MISSING_EXPR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("businessknowledgemodel/BKM_MISSING_EXPR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
        }
    }

    @Test
    public void testBKM_MISSING_EXPR_FileInput() {
        List validate = validator.validate(this.getFile("businessknowledgemodel/BKM_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
    }

    @Test
    public void testBKM_MISSING_EXPR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("businessknowledgemodel/BKM_MISSING_EXPR.dmn", "https://github.com/kiegroup/kie-dmn", "BKM_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)((DMNMessage)validate.get(0)).toString(), (Object)((DMNMessage)validate.get(0)).getMessageType(), (Matcher)CoreMatchers.is((Object)DMNMessageType.MISSING_EXPRESSION));
    }
}

