/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.runtime.events.HitPolicyViolationEvent;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDecisionTableHitPolicyTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNDecisionTableHitPolicyTest.class);

    public DMNDecisionTableHitPolicyTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUnique() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-U.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Assertions.assertThat((Object)result.get("Approval Status")).isEqualTo((Object)"Approved");
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUniqueSatisfies() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-U.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "ASD", false);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Approval Status")).isNull();
        Assert.assertTrue((dmnResult.getMessages().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUniqueNullWarn() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-U-noinputvalues.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U-noinputvalues");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        this.check_testSimpleDecisionTableHitPolicyUniqueNullWarn(runtime, dmnModel);
    }

    private void check_testSimpleDecisionTableHitPolicyUniqueNullWarn(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "ASD", false);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Approval Status")).isNull();
        Assert.assertTrue((dmnResult.getMessages().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dmnResult.getMessages().stream().anyMatch(dm -> dm.getSeverity().equals((Object)DMNMessage.Severity.WARN) && dm.getFeelEvent() instanceof HitPolicyViolationEvent && dm.getFeelEvent().getSeverity().equals((Object)FEELEvent.Severity.WARN)));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUniqueNullWarn_ctxe() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-U-noinputvalues-ctxe.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U-noinputvalues");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        this.check_testSimpleDecisionTableHitPolicyUniqueNullWarn(runtime, dmnModel);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyUniqueNullWarn_ctxr() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-U-noinputvalues-ctxr.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-U-noinputvalues");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        this.check_testSimpleDecisionTableHitPolicyUniqueNullWarn(runtime, dmnModel);
    }

    @Test
    public void testDecisionTableHitPolicyUnique() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"BranchDistribution.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_cdf29af2-959b-4004-8271-82a9f5a62147", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Branches dispersion", (Object)"Province");
        context.set("Number of Branches", (Object)BigDecimal.valueOf(10L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Branches distribution")).isEqualTo((Object)"Medium");
    }

    @Test
    public void testSimpleDecisionTableHitPolicyFirst() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-F.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-F");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Map decisionResult = (Map)result.get("Decision Result");
        Assertions.assertThat(decisionResult.values()).hasSize(2);
        Assertions.assertThat((Map)decisionResult).containsEntry((Object)"Approval Status", (Object)"Approved");
        Assertions.assertThat((Map)decisionResult).containsEntry((Object)"Decision Review", (Object)"Decision final");
    }

    @Test
    public void testSimpleDecisionTableHitPolicyAnyEqualRules() {
        this.testSimpleDecisionTableHitPolicyAny("0004-simpletable-A.dmn", "0004-simpletable-A", true);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyAnyNonEqualRules() {
        this.testSimpleDecisionTableHitPolicyAny("0004-simpletable-A-non-equal.dmn", "0004-simpletable-A-non-equal", false);
    }

    private void testSimpleDecisionTableHitPolicyAny(String resurceName, String modelName, boolean equalRules) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)resurceName, ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", modelName);
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        if (equalRules) {
            Assertions.assertThat((Object)result.get("Approval Status")).isEqualTo((Object)"Approved");
        } else {
            Assertions.assertThat((boolean)dmnResult.hasErrors()).isTrue();
            Assertions.assertThat((String)((String)result.get("Approval Status"))).isNullOrEmpty();
        }
    }

    @Test
    public void testSimpleDecisionTableHitPolicyPriority() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-P.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-P");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Assertions.assertThat((Object)result.get("Approval Status")).isEqualTo((Object)"Declined");
    }

    @Test
    public void testSimpleDecisionTableHitPolicyPriorityMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-P-multiple-outputs.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-P-multiple-outputs");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Map decisionResult = (Map)result.get("Decision Result");
        Assertions.assertThat(decisionResult.values()).hasSize(2);
        Assertions.assertThat((Map)decisionResult).containsEntry((Object)"Approval Status", (Object)"Declined");
        Assertions.assertThat((Map)decisionResult).containsEntry((Object)"Decision Review", (Object)"Needs verification");
    }

    @Test
    public void testSimpleDecisionTableHitPolicyOutputOrder() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-O.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-O");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResults = (List)result.get("Approval Status");
        Assertions.assertThat((List)decisionResults).hasSize(3);
        Assertions.assertThat((List)decisionResults).contains((Object[])new String[]{"Declined", "Declined", "Approved"});
    }

    @Test
    public void testSimpleDecisionTableHitPolicyOutputOrderMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-O-multiple-outputs.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-O-multiple-outputs");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(18L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResult = (List)result.get("Decision Result");
        Assertions.assertThat((List)decisionResult).hasSize(4);
        this.checkMultipleOutputResult((Map)decisionResult.get(0), "Declined", "Needs verification");
        this.checkMultipleOutputResult((Map)decisionResult.get(1), "Declined", "Decision final");
        this.checkMultipleOutputResult((Map)decisionResult.get(2), "Approved", "Needs verification");
        this.checkMultipleOutputResult((Map)decisionResult.get(3), "Approved", "Decision final");
    }

    private void checkMultipleOutputResult(Map<String, String> outputResult, String expectedApprovalStatus, String expectedDecisionReview) {
        Assertions.assertThat(outputResult).containsEntry((Object)"Approval Status", (Object)expectedApprovalStatus);
        Assertions.assertThat(outputResult).containsEntry((Object)"Decision Review", (Object)expectedDecisionReview);
    }

    @Test
    public void testSimpleDecisionTableHitPolicyRuleOrder() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-R.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-R");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        List decisionResults = (List)result.get("Approval Status");
        Assertions.assertThat((List)decisionResults).hasSize(3);
        Assertions.assertThat((List)decisionResults).contains((Object[])new String[]{"Approved", "Needs review", "Declined"});
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollect() {
        List<BigDecimal> decisionResults = this.executeTestDecisionTableHitPolicyCollect(this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
        Assertions.assertThat(decisionResults).hasSize(3);
        Assertions.assertThat(decisionResults).contains((Object[])new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(25L), BigDecimal.valueOf(13L)});
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectNoHits() {
        List<BigDecimal> decisionResults = this.executeTestDecisionTableHitPolicyCollect(this.getSimpleTableContext(BigDecimal.valueOf(5L), "Medium", true));
        Assertions.assertThat(decisionResults).hasSize(0);
    }

    private List<BigDecimal> executeTestDecisionTableHitPolicyCollect(DMNContext context) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-C.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-C");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        return (List)result.get("Status number");
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectSum() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-sum.dmn", "0004-simpletable-C-sum", BigDecimal.valueOf(48L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectSumMultipleOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-simpletable-C-sum-multiple-outputs.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0004-simpletable-C-sum-multiple-outputs");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Map decisionResult = (Map)result.get("Decision Result");
        Assertions.assertThat(decisionResult.values()).hasSize(2);
        Assertions.assertThat((Map)decisionResult).containsEntry((Object)"Value1", (Object)BigDecimal.valueOf(25L));
        Assertions.assertThat((Map)decisionResult).containsEntry((Object)"Value2", (Object)BigDecimal.valueOf(32L));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectMin() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-min.dmn", "0004-simpletable-C-min", BigDecimal.valueOf(10L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectMax() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-max.dmn", "0004-simpletable-C-max", BigDecimal.valueOf(25L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectCount() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-count.dmn", "0004-simpletable-C-count", BigDecimal.valueOf(3L), this.getSimpleTableContext(BigDecimal.valueOf(70L), "Medium", true));
    }

    @Test
    public void testSimpleDecisionTableHitPolicyCollectCountNoHits() {
        this.testSimpleDecisionTableHitPolicyCollectAggregateFunction("0004-simpletable-C-count.dmn", "0004-simpletable-C-count", BigDecimal.valueOf(0L), this.getSimpleTableContext(BigDecimal.valueOf(5L), "Medium", true));
    }

    private void testSimpleDecisionTableHitPolicyCollectAggregateFunction(String resourceName, String modelName, BigDecimal expectedResult, DMNContext context) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)resourceName, ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", modelName);
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext result = this.evaluateSimpleTableWithContext(dmnModel, runtime, context);
        Assertions.assertThat((Object)result.get("Status number")).isEqualTo((Object)expectedResult);
    }

    private DMNContext evaluateSimpleTableWithContext(DMNModel model, DMNRuntime runtime, DMNContext context) {
        DMNResult dmnResult = runtime.evaluateAll(model, context);
        return dmnResult.getContext();
    }

    private DMNContext getSimpleTableContext(BigDecimal age, String riskCategory, boolean isAffordable) {
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)age);
        context.set("RiskCategory", (Object)riskCategory);
        context.set("isAffordable", (Object)isAffordable);
        return context;
    }

    @Test
    public void testDecisionTableHitPolicyCollect() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Collect_Hit_Policy.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_da1a4dcb-01bf-4dee-9be8-f498bc68178c", "Collect Hit Policy");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Input", (Object)20);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Collect")).isEqualTo((Object)BigDecimal.valueOf(50L));
    }
}

