/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNAssemblerTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNAssemblerTest.class);

    public DMNAssemblerTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testDuplicateModel() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(ks.getResources().newClassPathResource("0001-input-data-string.dmn", ((Object)((Object)this)).getClass()));
        kfs.write(ks.getResources().newClassPathResource("duplicate.0001-input-data-string.dmn", ((Object)((Object)this)).getClass()));
        Results results = ks.newKieBuilder(kfs).buildAll().getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.ERROR}).forEach(e -> LOG.error("{}", e));
        Assertions.assertThat((List)results.getMessages(new Message.Level[]{Message.Level.ERROR})).hasSizeGreaterThan(0);
    }

    @Test
    public void testExtendedMode() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"strictMode.dmn", ((Object)((Object)this)).getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "strictMode");
        DMNContext ctx = runtime.newContext();
        ctx.set("timestring", (Object)"2016-12-20T14:30:22z");
        DMNResult result = runtime.evaluateAll(model, ctx);
        Assertions.assertThat((Object)result.getDecisionResultByName("time").getResult()).isEqualTo((Object)DateTimeFormatter.ISO_TIME.parse((CharSequence)"14:30:22z", OffsetTime::from));
    }

    @Test
    public void testStrictMode() {
        System.setProperty("org.kie.dmn.strictConformance", "true");
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"strictMode.dmn", ((Object)((Object)this)).getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "strictMode");
        DMNContext ctx = runtime.newContext();
        ctx.set("timestring", (Object)"2016-12-20T14:30:22z");
        DMNResult result = runtime.evaluateAll(model, ctx);
        Assertions.assertThat((Object)result.getDecisionResultByName("time").getResult()).isNull();
    }

    @Test
    public void testStrictModeProp() {
        KieServices services = KieServices.Factory.get();
        KieFileSystem fileSystem = services.newKieFileSystem();
        KieModuleModel moduleModel = services.newKieModuleModel();
        moduleModel.setConfigurationProperty("org.kie.dmn.strictConformance", "true");
        fileSystem.writeKModuleXML(moduleModel.toXML());
        fileSystem.write(services.getResources().newClassPathResource("strictMode.dmn", ((Object)((Object)this)).getClass()));
        services.newKieBuilder(fileSystem).buildAll();
        KieContainer container = services.newKieContainer(services.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)container.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "strictMode");
        DMNContext ctx = runtime.newContext();
        ctx.set("timestring", (Object)"2016-12-20T14:30:22z");
        DMNResult result = runtime.evaluateAll(model, ctx);
        Assertions.assertThat((Object)result.getDecisionResultByName("time").getResult()).isNull();
    }

    @After
    public void clearSystemProperty() {
        System.clearProperty("org.kie.dmn.strictConformance");
    }
}

