/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNUnaryTest;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;

public class DMNInputRuntimeTest
extends BaseDMN1_1VariantTest {
    public DMNInputRuntimeTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testInputStringEvaluateAll() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult()).isEqualTo((Object)"Hello John Doe");
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Greeting Message")).isEqualTo((Object)"Hello John Doe");
    }

    @Test
    public void testInputStringEvaluateDecisionByName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{"Greeting Message"});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult()).isEqualTo((Object)"Hello John Doe");
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Greeting Message")).isEqualTo((Object)"Hello John Doe");
        dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{"nonExistantName"});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
        dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{""});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
        dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{null});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
    }

    @Test
    public void testInputStringEvaluateDecisionById() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateById(dmnModel, context, new String[]{"d_GreetingMessage"});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultById("d_GreetingMessage").getResult()).isEqualTo((Object)"Hello John Doe");
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Greeting Message")).isEqualTo((Object)"Hello John Doe");
        dmnResult = runtime.evaluateById(dmnModel, context, new String[]{"nonExistantId"});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
        dmnResult = runtime.evaluateById(dmnModel, context, new String[]{""});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
        dmnResult = runtime.evaluateById(dmnModel, context, new String[]{null});
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("Greeting Message").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED);
    }

    @Test
    public void testInputStringAllowedValuesEvaluateAll() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0003-input-data-string-allowed-values.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0003-input-data-string-allowed-values");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Employment Status", (Object)"SELF-EMPLOYED");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Employment Status Statement")).isEqualTo((Object)"You are SELF-EMPLOYED");
    }

    @Test
    public void testInputStringNotInTypeScopeEvaluateAll() {
        this.testInputStringNotAllowedValuesEvaluateAll("NOT-ALLOWED-VALUE");
    }

    @Test
    public void testInputStringWrongTypeEvaluateAll() {
        this.testInputStringNotAllowedValuesEvaluateAll(new Object());
    }

    private void testInputStringNotAllowedValuesEvaluateAll(Object inputValue) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0003-input-data-string-allowed-values.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0003-input-data-string-allowed-values");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Employment Status", inputValue);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Employment Status Statement").getResult()).isEqualTo((Object)null);
        Assertions.assertThat((List)dmnResult.getMessages()).hasSize(1);
        Assertions.assertThat((Comparable)((DMNMessage)dmnResult.getMessages().get(0)).getSeverity()).isEqualTo((Object)DMNMessage.Severity.ERROR);
        Assertions.assertThat((List)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages()).hasSize(1);
        Assertions.assertThat((Comparable)((DMNMessage)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages().get(0)).getSeverity()).isEqualTo((Object)DMNMessage.Severity.ERROR);
    }

    @Test
    public void testInputNumberEvaluateAll() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0002-input-data-number.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0002-input-data-number");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Monthly Salary", (Object)new BigDecimal(1000));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Yearly Salary")).isEqualTo((Object)new BigDecimal(12000));
    }

    @Test
    public void testGetRequiredInputsByName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Set inputs = dmnModel.getRequiredInputsForDecisionName("Greeting Message");
        Assertions.assertThat((Collection)inputs).hasSize(1);
        Assertions.assertThat((String)((InputDataNode)inputs.iterator().next()).getName()).isEqualTo("Full Name");
        inputs = dmnModel.getRequiredInputsForDecisionName("nonExistantDecisionName");
        Assertions.assertThat((Collection)inputs).hasSize(0);
    }

    @Test
    public void testGetRequiredInputsById() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Set inputs = dmnModel.getRequiredInputsForDecisionId("d_GreetingMessage");
        Assertions.assertThat((Collection)inputs).hasSize(1);
        Assertions.assertThat((String)((InputDataNode)inputs.iterator().next()).getName()).isEqualTo("Full Name");
        inputs = dmnModel.getRequiredInputsForDecisionId("nonExistantId");
        Assertions.assertThat((Collection)inputs).hasSize(0);
    }

    @Test
    public void testNonexistantInputNodeName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Nonexistant Input", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult()).isEqualTo((Object)null);
        Assertions.assertThat((List)dmnResult.getMessages()).hasSize(1);
        Assertions.assertThat((Comparable)((DMNMessage)dmnResult.getMessages().get(0)).getSeverity()).isEqualTo((Object)DMNMessage.Severity.ERROR);
        Assertions.assertThat((List)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages()).hasSize(1);
        Assertions.assertThat((Comparable)((DMNMessage)((DMNDecisionResult)dmnResult.getDecisionResults().get(0)).getMessages().get(0)).getSeverity()).isEqualTo((Object)DMNMessage.Severity.ERROR);
    }

    @Test
    public void testAllowedValuesChecks() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"AllowedValuesChecks.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_238bd96d-47cd-4746-831b-504f3e77b442", "AllowedValuesChecks");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx1 = runtime.newContext();
        ctx1.set("p1", (Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Name", (Object)"P1"), DynamicTypeUtils.entry((Object)"Interests", Collections.singletonList("Golf"))}));
        DMNResult dmnResult1 = runtime.evaluateAll(dmnModel, ctx1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult1.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult1.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult1.getContext().get("MyDecision")).isEqualTo((Object)"The Person P1 likes 1 thing(s).");
        DMNContext ctx2 = runtime.newContext();
        ctx2.set("p1", (Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Name", (Object)"P2"), DynamicTypeUtils.entry((Object)"Interests", Collections.singletonList("x"))}));
        DMNResult dmnResult2 = runtime.evaluateAll(dmnModel, ctx2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult2.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult2.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult2.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.ERROR_EVAL_NODE))).isTrue();
        DMNContext ctx3 = runtime.newContext();
        ctx3.set("p1", (Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Name", (Object)"P3"), DynamicTypeUtils.entry((Object)"Interests", Arrays.asList("Golf", "Computer"))}));
        DMNResult dmnResult3 = runtime.evaluateAll(dmnModel, ctx3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult3.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult3.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult3.getContext().get("MyDecision")).isEqualTo((Object)"The Person P3 likes 2 thing(s).");
        DMNContext ctx4 = runtime.newContext();
        ctx4.set("p1", (Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Name", (Object)"P4"), DynamicTypeUtils.entry((Object)"Interests", Arrays.asList("Golf", "x"))}));
        DMNResult dmnResult4 = runtime.evaluateAll(dmnModel, ctx4);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult4.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult4.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult4.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.ERROR_EVAL_NODE))).isTrue();
    }

    @Test
    public void testDMNInputDataNodeTypeTest() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DMNInputDataNodeTypeTest.dmn", ((Object)((Object)this)).getClass());
        String MODEL_NAMESPACE = "http://www.trisotech.com/definitions/_17396034-163a-48aa-9a7f-c6eb17f9cc6c";
        String FEEL_NAMESPACE = "http://www.omg.org/spec/FEEL/20140401";
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_17396034-163a-48aa-9a7f-c6eb17f9cc6c", "DMNInputDataNodeTypeTest");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        InputDataNode idnMembership = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Membership Level")).findFirst().get();
        Assertions.assertThat((String)idnMembership.getType().getBaseType().getNamespace()).isEqualTo("http://www.omg.org/spec/FEEL/20140401");
        Assertions.assertThat((String)idnMembership.getType().getBaseType().getName()).isEqualTo("string");
        Assertions.assertThat((boolean)idnMembership.getType().isCollection()).isFalse();
        Assertions.assertThat((boolean)idnMembership.getType().isComposite()).isFalse();
        Assertions.assertThat((List)idnMembership.getType().getAllowedValues()).hasSize(3);
        Assertions.assertThat((String)((DMNUnaryTest)idnMembership.getType().getAllowedValues().get(0)).toString()).isEqualTo("\"Gold\"");
        Assertions.assertThat((String)((DMNUnaryTest)idnMembership.getType().getAllowedValues().get(1)).toString()).isEqualTo("\"Silver\"");
        Assertions.assertThat((String)((DMNUnaryTest)idnMembership.getType().getAllowedValues().get(2)).toString()).isEqualTo("\"None\"");
        InputDataNode idnMembershipLevels = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Membership Levels")).findFirst().get();
        Assertions.assertThat((String)idnMembershipLevels.getType().getBaseType().getNamespace()).isEqualTo("http://www.trisotech.com/definitions/_17396034-163a-48aa-9a7f-c6eb17f9cc6c");
        Assertions.assertThat((String)idnMembershipLevels.getType().getBaseType().getName()).isEqualTo("tMembershipLevel");
        Assertions.assertThat((boolean)idnMembershipLevels.getType().isCollection()).isTrue();
        Assertions.assertThat((boolean)idnMembershipLevels.getType().isComposite()).isFalse();
        Assertions.assertThat((List)idnMembershipLevels.getType().getAllowedValues()).isEmpty();
        InputDataNode idnPercent = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Percent")).findFirst().get();
        Assertions.assertThat((String)idnPercent.getType().getBaseType().getNamespace()).isEqualTo("http://www.omg.org/spec/FEEL/20140401");
        Assertions.assertThat((String)idnPercent.getType().getBaseType().getName()).isEqualTo("number");
        Assertions.assertThat((boolean)idnPercent.getType().isCollection()).isFalse();
        Assertions.assertThat((boolean)idnPercent.getType().isComposite()).isFalse();
        Assertions.assertThat((List)idnPercent.getType().getAllowedValues()).hasSize(1);
        Assertions.assertThat((String)((DMNUnaryTest)idnPercent.getType().getAllowedValues().get(0)).toString()).isEqualTo("[0..100]");
        InputDataNode idnCarDamageResponsibility = dmnModel.getInputs().stream().filter(idn -> idn.getName().equals("Car Damage Responsibility")).findFirst().get();
        Assertions.assertThat((Object)idnCarDamageResponsibility.getType().getBaseType()).isNull();
        Assertions.assertThat((boolean)idnCarDamageResponsibility.getType().isCollection()).isFalse();
        Assertions.assertThat((boolean)idnCarDamageResponsibility.getType().isComposite()).isTrue();
    }

    @Test
    public void testInputClauseTypeRefWithAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"actualInputMatchInputValues-forTypeRef.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("MyDecision")).isEqualTo((Object)"Decision taken");
    }

    @Test
    public void testInputDataTypeRefWithAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"actualInputMatchInputValues-forTypeRef.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"zzz");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((List)dmnResult.getMessages()).hasSize(1);
        Assertions.assertThat((String)((DMNMessage)dmnResult.getMessages().get(0)).getSourceId()).isEqualTo("_3d560678-a126-4654-a686-bc6d941fe40b");
    }

    @Test
    public void testMissingInputData() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"missing_input_data.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((Comparable)((DMNMessage)messages.get(0)).getMessageType()).isEqualTo((Object)DMNMessageType.ERR_COMPILING_FEEL);
    }
}

