/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DecisionCompiler;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.model.api.DMNElement;

@XStreamAlias(value="MultiInstanceDecisionLogic")
public class MultiInstanceDecisionLogic {
    @XStreamAlias(value="iterationExpression")
    private String iterationExpression;
    @XStreamAlias(value="iteratorShapeId")
    private String iteratorShapeId;
    @XStreamAlias(value="aggregationFunction")
    private String aggregationFunction;
    @XStreamAlias(value="topLevelDecisionId")
    private String topLevelDecisionId;

    public String getIterationExpression() {
        return this.iterationExpression;
    }

    public String getIteratorShapeId() {
        return this.iteratorShapeId;
    }

    public String getAggregationFunction() {
        return this.aggregationFunction;
    }

    public String getTopLevelDecisionId() {
        return this.topLevelDecisionId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultiInstanceDecisionLogic [iterationExpression=").append(this.iterationExpression).append(", iteratorShapeId=").append(this.iteratorShapeId).append(", aggregationFunction=").append(this.aggregationFunction).append(", topLevelDecisionId=").append(this.topLevelDecisionId).append("]");
        return builder.toString();
    }

    public static class MultiInstanceDecisionNodeEvaluator
    implements DMNExpressionEvaluator {
        private MultiInstanceDecisionLogic mi;
        private DMNModelImpl model;
        private DecisionNodeImpl di;
        private String contextIteratorName;
        private DecisionNodeImpl topLevelDecision;

        public MultiInstanceDecisionNodeEvaluator(MultiInstanceDecisionLogic mi, DMNModelImpl model, DecisionNodeImpl di) {
            this.mi = mi;
            this.model = model;
            this.di = di;
            this.contextIteratorName = model.getInputById(mi.iteratorShapeId).getName();
            this.topLevelDecision = (DecisionNodeImpl)model.getDecisionById(mi.topLevelDecisionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
            DMNResultImpl result = (DMNResultImpl)dmnr;
            DMNContext previousContext = result.getContext();
            DMNContextImpl dmnContext = (DMNContextImpl)previousContext.clone();
            result.setContext((DMNContext)dmnContext);
            ArrayList<Object> invokationResults = new ArrayList<Object>();
            try {
                Object cycleOnRaw = dmnContext.get(this.mi.iterationExpression);
                List<Object> cycleOn = null;
                cycleOn = cycleOnRaw instanceof Collection ? (List<Object>)cycleOnRaw : Arrays.asList(cycleOnRaw);
                for (Object e : cycleOn) {
                    DMNContext nonCycledContext = result.getContext();
                    DMNContextImpl cyclingContext = (DMNContextImpl)nonCycledContext.clone();
                    result.setContext((DMNContext)cyclingContext);
                    cyclingContext.set(this.contextIteratorName, e);
                    Object evaluationResult = this.topLevelDecision.getEvaluator().evaluate(eventManager, (DMNResult)result).getResult();
                    invokationResults.add(evaluationResult);
                    result.setContext(nonCycledContext);
                }
            }
            finally {
                result.setContext(previousContext);
            }
            return new EvaluatorResultImpl(invokationResults, EvaluatorResult.ResultType.SUCCESS);
        }
    }

    public static class MultiInstanceDecisionNodeCompiler
    extends DecisionCompiler {
        private Optional<MultiInstanceDecisionLogic> getMIDL(DMNNode node) {
            DecisionNodeImpl nodeImpl;
            DMNElement.ExtensionElements extElementsList;
            if (node instanceof DecisionNodeImpl && (extElementsList = (nodeImpl = (DecisionNodeImpl)node).getSource().getExtensionElements()) != null && extElementsList.getAny() != null) {
                return extElementsList.getAny().stream().filter(MultiInstanceDecisionLogic.class::isInstance).map(MultiInstanceDecisionLogic.class::cast).findFirst();
            }
            return Optional.empty();
        }

        public boolean accept(DMNNode node) {
            return this.getMIDL(node).isPresent();
        }

        public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
            DecisionNodeImpl di = (DecisionNodeImpl)node;
            MultiInstanceDecisionLogic midl = this.getMIDL(node).orElseThrow(() -> new IllegalStateException("Node doesn't contain multi instance decision logic!" + node.toString()));
            di.setEvaluator((DMNExpressionEvaluator)new MultiInstanceDecisionNodeEvaluator(midl, model, di));
            DecisionNodeImpl topLevelDecision = (DecisionNodeImpl)model.getDecisionById(midl.topLevelDecisionId);
            MultiInstanceDecisionNodeCompiler.recurseNodeToRemoveItAndDepsFromModelIndex((DMNNode)topLevelDecision, model);
        }

        public static void recurseNodeToRemoveItAndDepsFromModelIndex(DMNNode topLevelDecision, DMNModelImpl model) {
            model.removeDMNNodeFromIndexes(topLevelDecision);
            for (DMNNode dep : ((DMNBaseNode)topLevelDecision).getDependencies().values()) {
                MultiInstanceDecisionNodeCompiler.recurseNodeToRemoveItAndDepsFromModelIndex(dep, model);
            }
        }
    }
}

