/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.signavio.KieDMNSignavioProfile;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public abstract class ExtendedFunctionsBaseFEELTest {
    private final FEEL feel = FEEL.newInstance(Arrays.asList(new KieDMNSignavioProfile()));
    @Parameterized.Parameter(value=0)
    public String expression;
    @Parameterized.Parameter(value=1)
    public Object result;
    @Parameterized.Parameter(value=2)
    public FEELEvent.Severity severity;

    @Test
    public void testExpression() {
        FEELEventListener listener = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        this.feel.addListener(listener);
        this.feel.addListener(evt -> System.out.println(evt));
        this.assertResult(this.expression, this.result);
        if (this.severity != null) {
            ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
            ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).onEvent((FEELEvent)captor.capture());
            Assert.assertThat((Object)((FEELEvent)captor.getValue()).getSeverity(), (Matcher)org.hamcrest.Matchers.is((Object)this.severity));
        } else {
            ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onEvent((FEELEvent)Matchers.any(FEELEvent.class));
        }
    }

    protected void assertResult(String expression, Object result) {
        if (result == null) {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(expression), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
        } else if (result instanceof Class) {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(expression), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf((Class)((Class)result))));
        } else {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(expression), (Matcher)org.hamcrest.Matchers.is((Object)result));
        }
    }
}

