/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.DateFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class MonthAddFunction
extends BaseFEELFunction {
    public MonthAddFunction() {
        super("monthAdd");
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="datestring") String datetime, @ParameterName(value="months to add") BigDecimal months) {
        if (datetime == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datestring", "cannot be null"));
        }
        if (months == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "months to add", "cannot be null"));
        }
        try {
            Object r = null;
            r = datetime.contains("T") ? ((DateAndTimeFunction)BuiltInFunctions.getFunction(DateAndTimeFunction.class)).invoke(datetime).cata(BuiltInType.justNull(), Function.identity()) : ((DateFunction)BuiltInFunctions.getFunction(DateFunction.class)).invoke(datetime).cata(BuiltInType.justNull(), Function.identity());
            if (r != null && r instanceof TemporalAccessor) {
                return this.invoke((TemporalAccessor)r, months);
            }
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datestring", "date-parsing exception"));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datestring", "date-parsing exception", (Throwable)e));
        }
    }

    public FEELFnResult<TemporalAccessor> invoke(@ParameterName(value="datetime") TemporalAccessor datetime, @ParameterName(value="months to add") BigDecimal months) {
        if (datetime == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "cannot be null"));
        }
        if (months == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "months to add", "cannot be null"));
        }
        try {
            if (datetime instanceof Temporal) {
                return FEELFnResult.ofResult((Object)((Temporal)datetime).plus(months.longValue(), ChronoUnit.MONTHS));
            }
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "invalid 'date' or 'date and time' parameter"));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "invalid 'date' or 'date and time' parameter", (Throwable)e));
        }
    }
}

