/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class ModeFunction
extends BaseFEELFunction {
    public static final ModeFunction INSTANCE = new ModeFunction();

    ModeFunction() {
        super("mode");
    }

    public FEELFnResult<Object> invoke(@ParameterName(value="list") List<?> list) {
        if (list == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        if (list.isEmpty()) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be empty"));
        }
        Map collect = list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        long maxFreq = collect.values().stream().mapToLong(Long::longValue).max().orElse(-1L);
        List mostFrequents = collect.entrySet().stream().filter(kv -> (Long)kv.getValue() == maxFreq).map(Map.Entry::getKey).collect(Collectors.toList());
        if (mostFrequents.size() == 1) {
            return FEELFnResult.ofResult(mostFrequents.get(0));
        }
        return FEELFnResult.ofResult(mostFrequents.stream().sorted().collect(Collectors.toList()));
    }
}

