/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.math.BigDecimal;
import java.math.MathContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class PowerFunction
extends BaseFEELFunction {
    public PowerFunction() {
        super("power");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="base") BigDecimal base, @ParameterName(value="exponent") BigDecimal exponent) {
        if (base == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "base", "cannot be null"));
        }
        if (exponent == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "exponent", "cannot be null"));
        }
        return FEELFnResult.ofResult((Object)base.pow(exponent.intValue(), MathContext.DECIMAL128));
    }
}

