/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.runtime.functions.extended.TimeFunction;
import org.kie.dmn.feel.util.EvalHelper;

public class MinuteFunction
extends BaseFEELFunction {
    public MinuteFunction() {
        super("minute");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="timestring") String val) {
        if (val == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "timestring", "cannot be null"));
        }
        try {
            TemporalAccessor r = (TemporalAccessor)TimeFunction.INSTANCE.invoke(val).cata(BuiltInType.justNull(), Function.identity());
            if (r instanceof TemporalAccessor) {
                return this.invoke(r);
            }
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "timestring", "time-parsing exception"));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "timestring", "time-parsing exception", (Throwable)e));
        }
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="timestring") TemporalAccessor datetime) {
        if (datetime == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "timestring", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult((Object)EvalHelper.getBigDecimalOrNull((Object)datetime.get(ChronoField.MINUTE_OF_HOUR)));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "timestring", "invalid 'time' or 'date and time' parameter", (Throwable)e));
        }
    }
}

