/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.signavio.KieDMNSignavioProfile;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public abstract class ExtendedFunctionsBaseFEELTest {
    private final FEEL feel = FEEL.newInstance(List.of(new KieDMNSignavioProfile()));
    @Parameterized.Parameter(value=0)
    public String expression;
    @Parameterized.Parameter(value=1)
    public Object result;
    @Parameterized.Parameter(value=2)
    public FEELEvent.Severity severity;

    @Test
    public void testExpression() {
        FEELEventListener listener = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        this.feel.addListener(listener);
        this.feel.addListener(evt -> System.out.println(evt));
        this.assertResult(this.expression, this.result);
        if (this.severity != null) {
            ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
            ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).onEvent((FEELEvent)captor.capture());
            Assertions.assertThat((Comparable)((FEELEvent)captor.getValue()).getSeverity()).isEqualTo((Object)this.severity);
        } else {
            ((FEELEventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onEvent((FEELEvent)ArgumentMatchers.any(FEELEvent.class));
        }
    }

    protected void assertResult(String expression, Object result) {
        if (result == null) {
            ((ObjectAssert)Assertions.assertThat((Object)this.feel.evaluate(expression)).as("Evaluating: '" + expression + "'", new Object[0])).isNull();
        } else if (result instanceof Class) {
            ((ObjectAssert)Assertions.assertThat((Object)this.feel.evaluate(expression)).as("Evaluating: '" + expression + "'", new Object[0])).isInstanceOf((Class)result);
        } else {
            ((ObjectAssert)Assertions.assertThat((Object)this.feel.evaluate(expression)).as("Evaluating: '" + expression + "'", new Object[0])).isEqualTo(result);
        }
    }
}

