/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.xls2dmn.cli;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.xls2dmn.cli.App;
import org.kie.dmn.xls2dmn.cli.SameVMApp;
import org.kie.dmn.xls2dmn.cli.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CardApprovalTest {
    static final Logger LOG = LoggerFactory.getLogger(CardApprovalTest.class);

    private DMNRuntime getDMNRuntimeWithCLI() throws Exception {
        File tempFile = File.createTempFile("xls2dmn", ".dmn");
        return TestUtils.getRuntime(arg_0 -> ((CommandLine)new CommandLine((Object)new App())).execute(arg_0), tempFile, new String[]{"src/test/resources/Card_approval.xlsx", tempFile.toString()});
    }

    private DMNRuntime getDMNRuntimeWithSameVMApp() throws Exception {
        File tempFile = File.createTempFile("xls2dmn", ".dmn");
        return TestUtils.getRuntime(SameVMApp::main, tempFile, new String[]{"src/test/resources/Card_approval.xlsx", tempFile.toString()});
    }

    @Test
    public void testCLI() throws Exception {
        DMNRuntime dmnRuntime = this.getDMNRuntimeWithCLI();
        this.checkCardApprovalDMNModel(dmnRuntime);
    }

    @Test
    public void testSameVMApp() throws Exception {
        DMNRuntime dmnRuntime = this.getDMNRuntimeWithSameVMApp();
        this.checkCardApprovalDMNModel(dmnRuntime);
    }

    private void checkCardApprovalDMNModel(DMNRuntime dmnRuntime) {
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertThat((String)dmnModel.getName()).isEqualTo("Card_approval");
        Assertions.assertThat((String)dmnModel.getDefinitions().getId()).isNotNull();
        DMNContext dmnContext = dmnRuntime.newContext();
        dmnContext.set("Annual Income", (Object)70);
        dmnContext.set("Assets", (Object)150);
        DMNResult dmnResult = dmnRuntime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)dmnResult.getDecisionResultByName("Standard card score").getResult(), (Matcher)CoreMatchers.is((Object)new BigDecimal(562)));
        MatcherAssert.assertThat((Object)dmnResult.getDecisionResultByName("Gold card score").getResult(), (Matcher)CoreMatchers.is((Object)new BigDecimal(468)));
    }
}

