/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.xls2dmn.cli;

import java.io.File;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.xls2dmn.cli.TestUtils;
import org.kie.dmn.xls2dmn.cli.XLS2DMNParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLS2DMNParserTest {
    private static final Logger LOG = LoggerFactory.getLogger(XLS2DMNParserTest.class);
    private DMNRuntime dmnRuntime;
    private DMNModel dmnModel;

    private DMNRuntime getRuntimeLoanApprovalXslx() throws Exception {
        File tempFile = File.createTempFile("xls2dmn", ".dmn");
        new XLS2DMNParser(tempFile).parseFile(this.getClass().getResourceAsStream("/Loan_approvals.xlsx"));
        return TestUtils.validateRuntime(tempFile);
    }

    @Before
    public void init() throws Exception {
        this.dmnRuntime = this.getRuntimeLoanApprovalXslx();
        this.dmnModel = (DMNModel)this.dmnRuntime.getModels().get(0);
    }

    @Test
    public void testLoanApprovalXslx() {
        DMNContext dmnContext = this.dmnRuntime.newContext();
        dmnContext.set("DTI Ratio", (Object)1);
        dmnContext.set("PITI Ratio", (Object)1);
        dmnContext.set("FICO Score", (Object)650);
        DMNResult dmnResult = this.dmnRuntime.evaluateAll(this.dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Loan Approval").getResult()).isEqualTo((Object)"Not approved");
    }

    @Test
    public void testLoanApprovalXslx_Approved() {
        DMNContext dmnContext = this.dmnRuntime.newContext();
        dmnContext.set("DTI Ratio", (Object)0.1);
        dmnContext.set("PITI Ratio", (Object)0.1);
        dmnContext.set("FICO Score", (Object)800);
        DMNResult dmnResult = this.dmnRuntime.evaluateAll(this.dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Loan Approval").getResult()).isEqualTo((Object)"Approved");
    }
}

