/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.xls2dmn.cli;

import java.io.File;
import java.time.LocalDate;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.xls2dmn.cli.App;
import org.kie.dmn.xls2dmn.cli.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ChineseLunarYearsTest {
    private static final Logger LOG = LoggerFactory.getLogger(ChineseLunarYearsTest.class);

    @Test
    public void testCLI() throws Exception {
        File tempFile = File.createTempFile("xls2dmn", ".dmn");
        DMNRuntime dmnRuntime = TestUtils.getRuntime(arg_0 -> ((CommandLine)new CommandLine((Object)new App())).execute(arg_0), tempFile, new String[]{"src/test/resources/ChineseLunarYears.xlsx", tempFile.toString()});
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        DMNContext dmnContext = dmnRuntime.newContext();
        dmnContext.set("Date", (Object)LocalDate.of(2021, 4, 1));
        DMNResult dmnResult = dmnRuntime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Chinese Year").getResult()).isEqualTo((Object)"Golden Ox");
    }
}

