/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.backend.server;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class DashbuilderBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(DashbuilderBootstrap.class);
    private String jbpmDatasource = System.getProperty("org.kie.ds.jndi", "java:jboss/datasources/ExampleDS");
    public static final String HUMAN_TASKS_DATASET = "jbpmHumanTasks";
    public static final String HUMAN_TASKS_TABLE = "AuditTaskImpl";
    public static final String HUMAN_TASKS_WITH_USER_DATASET = "jbpmHumanTasksWithUser";
    public static final String HUMAN_TASKS_WITH_ADMIN_DATASET = "jbpmHumanTasksWithAdmin";
    public static final String PROCESS_INSTANCE_WITH_VARIABLES_DATASET = "jbpmProcessInstancesWithVariables";
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;

    @PostConstruct
    protected void init() {
        this.findDataSourceJNDI();
        this.registerDataSetDefinitions();
    }

    protected void registerDataSetDefinitions() {
        DataSetDef humanTasksDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(HUMAN_TASKS_DATASET)).name("Human tasks")).dataSource(this.jbpmDatasource).dbTable(HUMAN_TASKS_TABLE, false).date("activationTime")).label("actualOwner")).label("createdBy")).date("createdOn")).label("deploymentId")).text("description")).date("dueDate")).label("name")).number("parentId")).number("priority")).label("processId")).number("processInstanceId")).number("processSessionId")).label("status")).number("taskId")).number("workItemId")).buildDef();
        DataSetDef humanTasksWithUserDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(HUMAN_TASKS_WITH_USER_DATASET)).name("Human tasks and users")).dataSource(this.jbpmDatasource).dbSQL("select  t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, oe.id oeid from AuditTaskImpl t, PeopleAssignments_PotOwners po, OrganizationalEntity oe where t.taskId = po.task_id and po.entity_id = oe.id", false).date("activationTime")).label("actualOwner")).label("createdBy")).date("createdOn")).label("deploymentId")).text("description")).date("dueDate")).label("name")).number("parentId")).number("priority")).label("processId")).number("processInstanceId")).number("processSessionId")).label("status")).label("taskId")).number("workItemId")).label("oeid")).buildDef();
        DataSetDef humanTaskWithAdminDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(HUMAN_TASKS_WITH_ADMIN_DATASET)).name("Human tasks and admins")).dataSource(this.jbpmDatasource).dbSQL("select t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, oe.id oeid from AuditTaskImpl t, PeopleAssignments_BAs bas, OrganizationalEntity oe where t.taskId = bas.task_id and bas.entity_id = oe.id", false).date("activationTime")).label("actualOwner")).label("createdBy")).date("createdOn")).label("deploymentId")).text("description")).date("dueDate")).label("name")).number("parentId")).number("priority")).label("processId")).number("processInstanceId")).number("processSessionId")).label("status")).label("taskId")).number("workItemId")).label("oeid")).buildDef();
        DataSetDef processesWithVariablesDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(PROCESS_INSTANCE_WITH_VARIABLES_DATASET)).name("Domain Specific Process Instances")).dataSource(this.jbpmDatasource).dbSQL("select pil.processInstanceId pid,\n       pil.processId pname,\n       v.id varid,\n       v.variableId varname,\n       v.value varvalue\nfrom ProcessInstanceLog pil\n  inner join (select vil.processInstanceId ,vil.variableId, MAX(vil.ID) maxvilid  FROM VariableInstanceLog vil\n  GROUP BY vil.processInstanceId, vil.variableId)  x\n    on (x.processInstanceId =pil.processInstanceId)\n  INNER JOIN VariableInstanceLog v\n    ON (v.variableId = x.variableId  AND v.id = x.maxvilid )", false).number("pid")).label("pname")).number("varid")).label("varname")).label("varvalue")).buildDef();
        humanTasksDef.setPublic(false);
        humanTasksWithUserDef.setPublic(false);
        humanTaskWithAdminDef.setPublic(false);
        processesWithVariablesDef.setPublic(false);
        this.dataSetDefRegistry.registerDataSetDef(humanTasksDef);
        this.dataSetDefRegistry.registerDataSetDef(humanTasksWithUserDef);
        this.dataSetDefRegistry.registerDataSetDef(humanTaskWithAdminDef);
        this.dataSetDefRegistry.registerDataSetDef(processesWithVariablesDef);
    }

    protected void findDataSourceJNDI() {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/persistence.xml"));
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (!"jta-data-source".equals(reader.getLocalName())) break;
                        this.jbpmDatasource = reader.getElementText();
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.warn("Unable to find out JNDI name fo data source to be used for data sets due to {} using default {}", new Object[]{e.getMessage(), this.jbpmDatasource, e});
        }
    }
}

