/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.backend.server;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.metadata.attribute.OtherMetaView;
import org.guvnor.messageconsole.backend.DefaultIndexEngineObserver;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.backend.server.IOWatchServiceNonDotImpl;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.IOSearchIndex;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.io.IOSearchService;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.io.impl.cluster.IOServiceClusterImpl;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.impl.authz.RuntimeAuthorizationManager;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class ApplicationScopedProducer {
    private IOService ioService;
    private IOSearchService ioSearchService;
    private AuthorizationManager authorizationManager = new RuntimeAuthorizationManager();
    @Inject
    @Named(value="luceneConfig")
    private LuceneConfig config;
    @Inject
    private IOWatchServiceNonDotImpl watchService;
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private DefaultIndexEngineObserver defaultIndexEngineObserver;

    public ApplicationScopedProducer() {
        if (System.getProperty("org.uberfire.watcher.autostart") == null) {
            System.setProperty("org.uberfire.watcher.autostart", "false");
        }
        if (System.getProperty("org.kie.deployment.desc.location") == null) {
            System.setProperty("org.kie.deployment.desc.location", "classpath:META-INF/kie-wb-deployment-descriptor.xml");
        }
    }

    @PostConstruct
    public void setup() {
        IOServiceIndexedImpl service = new IOServiceIndexedImpl((IOWatchService)this.watchService, this.config.getIndexEngine(), (Observer)this.defaultIndexEngineObserver, new Class[]{DublinCoreView.class, VersionAttributeView.class, OtherMetaView.class});
        this.ioService = this.clusterServiceFactory == null ? service : new IOServiceClusterImpl((IOService)service, this.clusterServiceFactory, false);
        this.ioSearchService = new IOSearchIndex(this.config.getSearchIndex(), this.ioService);
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }

    @Produces
    @Named(value="ioSearchStrategy")
    public IOSearchService ioSearchService() {
        return this.ioSearchService;
    }

    @Produces
    public AuthorizationManager getAuthManager() {
        return this.authorizationManager;
    }

    @Produces
    @RequestScoped
    public User getIdentity() {
        try {
            return this.authenticationService.getUser();
        }
        catch (IllegalStateException ex) {
            return new UserImpl("system");
        }
    }
}

