/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.backend.server;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.shared.security.KieWorkbenchPolicy;
import org.guvnor.common.services.shared.security.KieWorkbenchSecurityService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jbpm.console.ng.bd.service.AdministrationService;
import org.kie.internal.utils.KieMeta;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.drools.backend.server.AppSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class AppSetup {
    private static final Logger logger = LoggerFactory.getLogger(AppSetup.class);
    private static final String OU_NAME = "demo";
    private static final String OU_OWNER = "demo@demo.org";
    private static final String DROOLS_WB_PLAYGROUND_SCHEME = "git";
    private static final String DROOLS_WB_PLAYGROUND_ALIAS = "uf-playground";
    private static final String DROOLS_WB_PLAYGROUND_ORIGIN = "https://github.com/guvnorngtestuser1/guvnorng-playground.git";
    private static final String DROOLS_WB_PLAYGROUND_UID = "guvnorngtestuser1";
    private static final String DROOLS_WB_PLAYGROUND_PWD = "test1234";
    private static final String GLOBAL_SETTINGS = "settings";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private KieProjectService projectService;
    @Inject
    private Event<ApplicationStarted> applicationStartedEvent;
    @Inject
    private KieWorkbenchSecurityService securityService;
    @Inject
    private AdministrationService administrationService;

    @PostConstruct
    public void assertPlayground() {
        try {
            this.configurationService.startBatch();
            String exampleRepositoriesRoot = System.getProperty("org.kie.example.repositories");
            if (exampleRepositoriesRoot != null && !"".equalsIgnoreCase(exampleRepositoriesRoot)) {
                this.loadExampleRepositories(exampleRepositoriesRoot);
            } else if (!KieMeta.isProductized()) {
                if (!"false".equalsIgnoreCase(System.getProperty("org.kie.demo"))) {
                    Repository repository = this.createRepository(DROOLS_WB_PLAYGROUND_ALIAS, DROOLS_WB_PLAYGROUND_SCHEME, DROOLS_WB_PLAYGROUND_ORIGIN, DROOLS_WB_PLAYGROUND_UID, DROOLS_WB_PLAYGROUND_PWD);
                    this.createOU(repository, OU_NAME, OU_OWNER);
                }
            } else if ("true".equalsIgnoreCase(System.getProperty("org.kie.example"))) {
                Repository exampleRepo = this.createRepository("repository1", DROOLS_WB_PLAYGROUND_SCHEME, null, "", "");
                this.createOU(exampleRepo, "example", "");
                this.createProject(exampleRepo, "org.kie.example", "project1", "1.0.0-SNAPSHOT");
            }
            List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
            boolean globalSettingsDefined = false;
            for (ConfigGroup globalConfigGroup : globalConfigGroups) {
                if (!GLOBAL_SETTINGS.equals(globalConfigGroup.getName())) continue;
                globalSettingsDefined = true;
                ConfigItem runtimeDeployConfig = globalConfigGroup.getConfigItem("support.runtime.deploy");
                if (runtimeDeployConfig == null) {
                    globalConfigGroup.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "false"));
                    this.configurationService.updateConfiguration(globalConfigGroup);
                    break;
                }
                if (((String)runtimeDeployConfig.getValue()).equalsIgnoreCase("false")) break;
                runtimeDeployConfig.setValue((Object)"false");
                this.configurationService.updateConfiguration(globalConfigGroup);
                break;
            }
            if (!globalSettingsDefined) {
                this.configurationService.addConfiguration(this.getGlobalConfiguration());
            }
            List editorConfigGroups = this.configurationService.getConfiguration(ConfigType.EDITOR);
            boolean workItemsEditorSettingsDefined = false;
            for (ConfigGroup editorConfigGroup : editorConfigGroups) {
                if (!"work-items-editor-settings".equals(editorConfigGroup.getName())) continue;
                workItemsEditorSettingsDefined = true;
                break;
            }
            if (!workItemsEditorSettingsDefined) {
                this.configurationService.addConfiguration(this.getWorkItemElementDefinitions());
            }
            KieWorkbenchPolicy policy = new KieWorkbenchPolicy(this.securityService.loadPolicy());
            for (Map.Entry entry : policy.entrySet()) {
                if (!((String)entry.getKey()).startsWith("roles.")) continue;
                String role = (String)entry.getValue();
                RoleRegistry.get().registerRole(role);
            }
            this.administrationService.bootstrapConfig();
            this.administrationService.bootstrapDeployments();
            this.applicationStartedEvent.fire((Object)new ApplicationStarted());
        }
        catch (Exception e) {
            logger.error("Error during update config", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    private void loadExampleRepositories(String exampleRepositoriesRoot) {
        File root = new File(exampleRepositoriesRoot);
        if (!root.isDirectory()) {
            logger.error("System Property 'org.kie.example.repositories' does not point to a folder.");
        } else {
            logger.info("Creating Organizational Unit 'demo'.");
            OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(OU_NAME);
            if (organizationalUnit == null) {
                ArrayList repositories = new ArrayList();
                organizationalUnit = this.organizationalUnitService.createOrganizationalUnit(OU_NAME, OU_OWNER, null, repositories);
                logger.info("Created Organizational Unit 'demo'.");
            } else {
                logger.info("Organizational Unit 'demo' already exists.");
            }
            1 filter = new /* Unavailable Anonymous Inner Class!! */;
            logger.info("Cloning Example Repositories.");
            for (File child : root.listFiles((FileFilter)filter)) {
                String repositoryAlias = child.getName();
                String repositoryOrigin = child.getAbsolutePath();
                logger.info("Cloning Repository '" + repositoryAlias + "' from '" + repositoryOrigin + "'.");
                Repository repository = this.repositoryService.getRepository(repositoryAlias);
                if (repository == null) {
                    try {
                        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
                        configurations.setOrigin(repositoryOrigin);
                        repository = this.repositoryService.createRepository(DROOLS_WB_PLAYGROUND_SCHEME, repositoryAlias, configurations);
                        this.organizationalUnitService.addRepository(organizationalUnit, repository);
                    }
                    catch (Exception e) {
                        logger.error("Failed to clone Repository '" + repositoryAlias + "'", (Throwable)e);
                    }
                    continue;
                }
                logger.info("Repository '" + repositoryAlias + "' already exists.");
            }
            logger.info("Example Repositories cloned.");
        }
    }

    private ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, GLOBAL_SETTINGS, "");
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.dateformat", "dd-MMM-yyyy"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.datetimeformat", "dd-MMM-yyyy HH:mm:ss"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultlanguage", "en"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultcountry", "US"));
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("rule-modeller-onlyShowDSLStatements", "false"));
        group.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "false"));
        return group;
    }

    private ConfigGroup getWorkItemElementDefinitions() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.EDITOR, "work-items-editor-settings", "");
        group.addConfigItem(this.configurationFactory.newConfigItem("Definition", "import org.drools.core.process.core.datatype.impl.type.StringDataType;\nimport org.drools.core.process.core.datatype.impl.type.ObjectDataType;\n\n[\n  [\n    \"name\" : \"MyTask|\", \n    \"parameters\" : [ \n        \"MyFirstParam\" : new StringDataType(), \n        \"MySecondParam\" : new StringDataType(), \n        \"MyThirdParam\" : new ObjectDataType() \n    ], \n    \"results\" : [ \n        \"Result\" : new ObjectDataType(\"java.util.Map\") \n    ], \n    \"displayName\" : \"My Task\", \n    \"icon\" : \"\" \n  ]\n]"));
        group.addConfigItem(this.configurationFactory.newConfigItem("Parameter", "\"MyParam|\" : new StringDataType()"));
        group.addConfigItem(this.configurationFactory.newConfigItem("Result", "\"Result|\" : new ObjectDataType()"));
        group.addConfigItem(this.configurationFactory.newConfigItem("DisplayName", "\"displayName\" : \"My Task|\""));
        return group;
    }

    private Repository createRepository(String alias, String scheme, String origin, String user, String password) {
        Repository repository = this.repositoryService.getRepository(alias);
        if (repository == null) {
            RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
            if (origin != null) {
                configurations.setOrigin(origin);
            }
            configurations.setUserName(user);
            configurations.setPassword(password);
            repository = this.repositoryService.createRepository(scheme, alias, configurations);
        }
        return repository;
    }

    private OrganizationalUnit createOU(Repository repository, String ouName, String ouOwner) {
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(ouName);
        if (ou == null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            repositories.add(repository);
            this.organizationalUnitService.createOrganizationalUnit(ouName, ouOwner, null, repositories);
        }
        return ou;
    }

    private void createProject(Repository repository, String group, String artifact, String version) {
        GAV gav = new GAV(group, artifact, version);
        try {
            if (repository != null) {
                String projectLocation = repository.getUri() + this.ioService.getFileSystem(URI.create(repository.getUri())).getSeparator() + artifact;
                if (!this.ioService.exists(this.ioService.get(URI.create(projectLocation)))) {
                    this.projectService.newProject(repository.getBranchRoot(repository.getDefaultBranch()), new POM(gav), "/");
                }
            } else {
                logger.error("Repository was not found (is null), cannot add project");
            }
        }
        catch (Exception e) {
            logger.error("Unable to bootstrap project {} in repository {}", new Object[]{gav, repository.getAlias(), e});
        }
    }
}

