/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.Os;
import org.eclipse.aether.RepositorySystemSession;
import org.kie.scanner.MavenRepositoryConfiguration;
import org.kie.scanner.embedder.ComponentProvider;
import org.kie.scanner.embedder.MavenEmbedderException;
import org.kie.scanner.embedder.MavenEmbedderUtils;
import org.kie.scanner.embedder.MavenRequest;
import org.kie.scanner.embedder.MavenSettings;

public class MavenEmbedder {
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    private final MavenRequest mavenRequest;
    private final ComponentProvider componentProvider;
    private MavenExecutionRequest mavenExecutionRequest;

    public MavenEmbedder(MavenRequest mavenRequest) throws MavenEmbedderException {
        this(Thread.currentThread().getContextClassLoader(), null, mavenRequest);
    }

    public MavenEmbedder(ClassLoader mavenClassLoader, ClassLoader parent, MavenRequest mavenRequest) throws MavenEmbedderException {
        this(mavenRequest, MavenEmbedderUtils.buildComponentProvider(mavenClassLoader, parent, mavenRequest));
    }

    private MavenEmbedder(MavenRequest mavenRequest, ComponentProvider componentProvider) throws MavenEmbedderException {
        this.mavenRequest = mavenRequest;
        this.componentProvider = componentProvider;
        try {
            this.mavenExecutionRequest = this.buildMavenExecutionRequest(mavenRequest);
            RepositorySystemSession rss = ((DefaultMaven)componentProvider.lookup(Maven.class)).newRepositorySession(this.mavenExecutionRequest);
            MavenSession mavenSession = new MavenSession(componentProvider.getPlexusContainer(), rss, this.mavenExecutionRequest, (MavenExecutionResult)new DefaultMavenExecutionResult());
            componentProvider.lookup(LegacySupport.class).setSession(mavenSession);
        }
        catch (MavenEmbedderException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    protected MavenExecutionRequest buildMavenExecutionRequest(MavenRequest mavenRequest) throws MavenEmbedderException, ComponentLookupException {
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        if (mavenRequest.getGlobalSettingsFile() != null) {
            mavenExecutionRequest.setGlobalSettingsFile(new File(mavenRequest.getGlobalSettingsFile()));
        }
        if (mavenRequest.getUserSettingsFile() != null) {
            mavenExecutionRequest.setUserSettingsFile(new File(mavenRequest.getUserSettingsFile()));
        }
        try {
            this.componentProvider.lookup(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)mavenExecutionRequest, this.getSettings());
            this.componentProvider.lookup(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)mavenExecutionRequest);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        ArtifactRepository localRepository = this.getLocalRepository();
        mavenExecutionRequest.setLocalRepository(localRepository);
        mavenExecutionRequest.setLocalRepositoryPath(localRepository.getBasedir());
        mavenExecutionRequest.setOffline(mavenRequest.isOffline());
        mavenExecutionRequest.setUpdateSnapshots(mavenRequest.isUpdateSnapshots());
        mavenExecutionRequest.setTransferListener(mavenRequest.getTransferListener());
        mavenExecutionRequest.setCacheNotFound(mavenRequest.isCacheNotFound());
        mavenExecutionRequest.setCacheTransferError(true);
        mavenExecutionRequest.setUserProperties(mavenRequest.getUserProperties());
        mavenExecutionRequest.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        if (mavenRequest.getSystemProperties() != null) {
            mavenExecutionRequest.getSystemProperties().putAll((Map<?, ?>)mavenRequest.getSystemProperties());
        }
        mavenExecutionRequest.getSystemProperties().putAll((Map<?, ?>)this.getEnvVars());
        if (mavenRequest.getProfiles() != null && !mavenRequest.getProfiles().isEmpty()) {
            for (String id : mavenRequest.getProfiles()) {
                Profile p = new Profile();
                p.setId(id);
                p.setSource("cli");
                mavenExecutionRequest.addProfile(p);
                mavenExecutionRequest.addActiveProfile(id);
            }
        }
        for (ArtifactRepository artifactRepository : this.getMavenRepositoryConfiguration().getArtifactRepositoriesForRequest()) {
            mavenExecutionRequest.addRemoteRepository(artifactRepository);
        }
        mavenExecutionRequest.setLoggingLevel(mavenRequest.getLoggingLevel());
        this.componentProvider.lookup(Logger.class).setThreshold(mavenRequest.getLoggingLevel());
        mavenExecutionRequest.setExecutionListener(mavenRequest.getExecutionListener()).setInteractiveMode(mavenRequest.isInteractive()).setGlobalChecksumPolicy(mavenRequest.getGlobalChecksumPolicy()).setGoals(mavenRequest.getGoals());
        if (mavenRequest.getPom() != null) {
            mavenExecutionRequest.setPom(new File(mavenRequest.getPom()));
        }
        if (mavenRequest.getWorkspaceReader() != null) {
            mavenExecutionRequest.setWorkspaceReader(mavenRequest.getWorkspaceReader());
        }
        return mavenExecutionRequest;
    }

    protected MavenRepositoryConfiguration getMavenRepositoryConfiguration() {
        return MavenSettings.getMavenRepositoryConfiguration();
    }

    private Properties getEnvVars() {
        Properties envVars = new Properties();
        boolean caseSensitive = !Os.isFamily((String)"windows");
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = "env." + (caseSensitive ? entry.getKey() : entry.getKey().toUpperCase(Locale.ENGLISH));
            envVars.setProperty(key, entry.getValue());
        }
        return envVars;
    }

    public Settings getSettings() throws MavenEmbedderException, ComponentLookupException {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        if (this.mavenRequest.getGlobalSettingsFile() != null) {
            settingsBuildingRequest.setGlobalSettingsFile(new File(this.mavenRequest.getGlobalSettingsFile()));
        } else {
            settingsBuildingRequest.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        }
        if (this.mavenRequest.getUserSettingsFile() != null) {
            settingsBuildingRequest.setUserSettingsFile(new File(this.mavenRequest.getUserSettingsFile()));
        } else {
            File userSettingsFile = MavenSettings.getUserSettingsFile();
            if (userSettingsFile != null) {
                settingsBuildingRequest.setUserSettingsFile(userSettingsFile);
            }
        }
        settingsBuildingRequest.setUserProperties(this.mavenRequest.getUserProperties());
        settingsBuildingRequest.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        settingsBuildingRequest.getSystemProperties().putAll((Map<?, ?>)this.mavenRequest.getSystemProperties());
        settingsBuildingRequest.getSystemProperties().putAll((Map<?, ?>)this.getEnvVars());
        try {
            return this.componentProvider.lookup(SettingsBuilder.class).build((SettingsBuildingRequest)settingsBuildingRequest).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    public ArtifactRepository getLocalRepository() throws ComponentLookupException {
        try {
            String localRepositoryPath = this.getLocalRepositoryPath();
            if (localRepositoryPath != null) {
                return this.componentProvider.lookup(RepositorySystem.class).createLocalRepository(new File(localRepositoryPath));
            }
            return this.componentProvider.lookup(RepositorySystem.class).createLocalRepository(RepositorySystem.defaultUserLocalRepository);
        }
        catch (InvalidRepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getLocalRepositoryPath() {
        String path = null;
        try {
            Settings settings = this.getSettings();
            path = settings.getLocalRepository();
        }
        catch (MavenEmbedderException mavenEmbedderException) {
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        if (this.mavenRequest.getLocalRepositoryPath() != null) {
            path = this.mavenRequest.getLocalRepositoryPath();
        }
        if (path == null) {
            path = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return path;
    }

    public MavenProject readProject(final InputStream mavenProjectStream) throws ProjectBuildingException, MavenEmbedderException {
        ModelSource modelSource = new ModelSource(){

            public InputStream getInputStream() throws IOException {
                return mavenProjectStream;
            }

            public String getLocation() {
                return "";
            }
        };
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Exception depedencyResolutionException;
            Thread.currentThread().setContextClassLoader(this.componentProvider.getSystemClassLoader());
            ProjectBuilder projectBuilder = this.componentProvider.lookup(ProjectBuilder.class);
            ProjectBuildingResult result = projectBuilder.build(modelSource, this.getProjectBuildingRequest());
            if (result != null && result.getDependencyResolutionResult() != null && !result.getDependencyResolutionResult().getCollectionErrors().isEmpty() && (depedencyResolutionException = (Exception)result.getDependencyResolutionResult().getCollectionErrors().get(0)) != null) {
                throw new MavenEmbedderException(depedencyResolutionException.getMessage(), depedencyResolutionException);
            }
            MavenProject mavenProject = result.getProject();
            return mavenProject;
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            try {
                mavenProjectStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public MavenProject readProject(File mavenProject) throws ProjectBuildingException, MavenEmbedderException {
        List<MavenProject> projects = this.readProjects(mavenProject, false);
        return projects == null || projects.isEmpty() ? null : projects.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> readProjects(File mavenProject, boolean recursive) throws ProjectBuildingException, MavenEmbedderException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.componentProvider.getSystemClassLoader());
            List<ProjectBuildingResult> results = this.buildProjects(mavenProject, recursive);
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(results.size());
            for (ProjectBuildingResult result : results) {
                projects.add(result.getProject());
            }
            ArrayList<MavenProject> arrayList = projects;
            return arrayList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    public List<ProjectBuildingResult> buildProjects(File mavenProject, boolean recursive) throws ProjectBuildingException, MavenEmbedderException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.componentProvider.getSystemClassLoader());
            ProjectBuilder projectBuilder = this.componentProvider.lookup(ProjectBuilder.class);
            List list = projectBuilder.build(Collections.singletonList(mavenProject), recursive, this.getProjectBuildingRequest());
            return list;
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    private ProjectBuildingRequest getProjectBuildingRequest() throws ComponentLookupException {
        ProjectBuildingRequest projectBuildingRequest = this.mavenExecutionRequest.getProjectBuildingRequest();
        projectBuildingRequest.setValidationLevel(this.mavenRequest.getValidationLevel());
        RepositorySystemSession repositorySystemSession = this.componentProvider.getRepositorySystemSession(this.mavenExecutionRequest);
        projectBuildingRequest.setRepositorySession(repositorySystemSession);
        projectBuildingRequest.setProcessPlugins(this.mavenRequest.isProcessPlugins());
        projectBuildingRequest.setResolveDependencies(this.mavenRequest.isResolveDependencies());
        return projectBuildingRequest;
    }
}

