/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OptimisticLockRetryPolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.SynchronousExecutorService;

@Metadata(label="eip,routing")
@XmlRootElement(name="aggregate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregateDefinition
extends ProcessorDefinition<AggregateDefinition>
implements ExecutorServiceAwareDefinition<AggregateDefinition> {
    @XmlElement(name="correlationExpression", required=true)
    private ExpressionSubElementDefinition correlationExpression;
    @XmlElement(name="completionPredicate")
    private ExpressionSubElementDefinition completionPredicate;
    @XmlElement(name="completionTimeout")
    private ExpressionSubElementDefinition completionTimeoutExpression;
    @XmlElement(name="completionSize")
    private ExpressionSubElementDefinition completionSizeExpression;
    @XmlElement(name="optimisticLockRetryPolicy")
    private OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition;
    @XmlTransient
    private ExpressionDefinition expression;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlTransient
    private ScheduledExecutorService timeoutCheckerExecutorService;
    @XmlTransient
    private AggregationRepository aggregationRepository;
    @XmlTransient
    private OptimisticLockRetryPolicy optimisticLockRetryPolicy;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private Boolean optimisticLocking;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private String timeoutCheckerExecutorServiceRef;
    @XmlAttribute
    private String aggregationRepositoryRef;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    private Boolean strategyMethodAllowNull;
    @XmlAttribute
    private Integer completionSize;
    @XmlAttribute
    private Long completionInterval;
    @XmlAttribute
    private Long completionTimeout;
    @XmlAttribute
    private Boolean completionFromBatchConsumer;
    @XmlAttribute
    @Deprecated
    private Boolean groupExchanges;
    @XmlAttribute
    private Boolean eagerCheckCompletion;
    @XmlAttribute
    private Boolean ignoreInvalidCorrelationKeys;
    @XmlAttribute
    private Integer closeCorrelationKeyOnCompletion;
    @XmlAttribute
    private Boolean discardOnCompletionTimeout;
    @XmlAttribute
    private Boolean forceCompletionOnStop;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    public AggregateDefinition() {
    }

    public AggregateDefinition(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(predicate));
        }
    }

    public AggregateDefinition(Expression correlationExpression) {
        if (correlationExpression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        }
    }

    public AggregateDefinition(ExpressionDefinition correlationExpression) {
        this.expression = correlationExpression;
    }

    public AggregateDefinition(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        return "Aggregate[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        return this.getExpression() != null ? this.getExpression().getLabel() : "";
    }

    @Override
    public String getLabel() {
        return "aggregate[" + this.description() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createAggregator(routeContext);
    }

    protected AggregateProcessor createAggregator(RouteContext routeContext) throws Exception {
        Expression expression;
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        String routeId = routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory());
        CamelInternalProcessor internal = new CamelInternalProcessor(childProcessor);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeId));
        internal.addAdvice(new CamelInternalProcessor.RouteContextAdvice(routeContext));
        Expression correlation = this.getExpression().createExpression(routeContext);
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        boolean parallel = this.getParallelProcessing() != null && this.getParallelProcessing() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, parallel);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "Aggregator", this, parallel);
        if (threadPool == null && !parallel) {
            threadPool = new SynchronousExecutorService();
            shutdownThreadPool = true;
        }
        AggregateProcessor answer = new AggregateProcessor(routeContext.getCamelContext(), internal, correlation, strategy, threadPool, shutdownThreadPool);
        AggregationRepository repository = this.createAggregationRepository(routeContext);
        if (repository != null) {
            answer.setAggregationRepository(repository);
        }
        boolean shutdownTimeoutThreadPool = false;
        ScheduledExecutorService timeoutThreadPool = this.timeoutCheckerExecutorService;
        if (timeoutThreadPool == null && this.timeoutCheckerExecutorServiceRef != null && (timeoutThreadPool = routeContext.getCamelContext().getRegistry().lookupByNameAndType(this.timeoutCheckerExecutorServiceRef, ScheduledExecutorService.class)) == null) {
            timeoutThreadPool = routeContext.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateTimeoutChecker", this.timeoutCheckerExecutorServiceRef);
            if (timeoutThreadPool == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + this.timeoutCheckerExecutorServiceRef + " not found in registry or as a thread pool profile.");
            }
            shutdownTimeoutThreadPool = true;
        }
        answer.setTimeoutCheckerExecutorService(timeoutThreadPool);
        answer.setShutdownTimeoutCheckerExecutorService(shutdownTimeoutThreadPool);
        answer.setParallelProcessing(parallel);
        if (this.getOptimisticLocking() != null) {
            answer.setOptimisticLocking(this.getOptimisticLocking());
        }
        if (this.getCompletionPredicate() != null) {
            Predicate predicate = this.getCompletionPredicate().createPredicate(routeContext);
            answer.setCompletionPredicate(predicate);
        } else if (strategy instanceof Predicate) {
            this.log.debug("Using AggregationStrategy as completion predicate: {}", (Object)strategy);
            answer.setCompletionPredicate((Predicate)((Object)strategy));
        }
        if (this.getCompletionTimeoutExpression() != null) {
            expression = this.getCompletionTimeoutExpression().createExpression(routeContext);
            answer.setCompletionTimeoutExpression(expression);
        }
        if (this.getCompletionTimeout() != null) {
            answer.setCompletionTimeout(this.getCompletionTimeout());
        }
        if (this.getCompletionInterval() != null) {
            answer.setCompletionInterval(this.getCompletionInterval());
        }
        if (this.getCompletionSizeExpression() != null) {
            expression = this.getCompletionSizeExpression().createExpression(routeContext);
            answer.setCompletionSizeExpression(expression);
        }
        if (this.getCompletionSize() != null) {
            answer.setCompletionSize(this.getCompletionSize());
        }
        if (this.getCompletionFromBatchConsumer() != null) {
            answer.setCompletionFromBatchConsumer(this.getCompletionFromBatchConsumer());
        }
        if (this.getEagerCheckCompletion() != null) {
            answer.setEagerCheckCompletion(this.getEagerCheckCompletion());
        }
        if (this.getIgnoreInvalidCorrelationKeys() != null) {
            answer.setIgnoreInvalidCorrelationKeys(this.getIgnoreInvalidCorrelationKeys());
        }
        if (this.getCloseCorrelationKeyOnCompletion() != null) {
            answer.setCloseCorrelationKeyOnCompletion(this.getCloseCorrelationKeyOnCompletion());
        }
        if (this.getDiscardOnCompletionTimeout() != null) {
            answer.setDiscardOnCompletionTimeout(this.getDiscardOnCompletionTimeout());
        }
        if (this.getForceCompletionOnStop() != null) {
            answer.setForceCompletionOnStop(this.getForceCompletionOnStop());
        }
        if (this.optimisticLockRetryPolicy == null) {
            if (this.getOptimisticLockRetryPolicyDefinition() != null) {
                answer.setOptimisticLockRetryPolicy(this.getOptimisticLockRetryPolicyDefinition().createOptimisticLockRetryPolicy());
            }
        } else {
            answer.setOptimisticLockRetryPolicy(this.optimisticLockRetryPolicy);
        }
        return answer;
    }

    @Override
    public void configureChild(ProcessorDefinition<?> output) {
        ExpressionClause clause;
        if (this.expression != null && this.expression instanceof ExpressionClause && (clause = (ExpressionClause)this.expression).getExpressionType() != null) {
            this.expression = clause.getExpressionType();
            this.correlationExpression = new ExpressionSubElementDefinition();
            this.correlationExpression.setExpressionType(clause.getExpressionType());
        }
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            Object aggStrategy = routeContext.lookup(this.strategyRef, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.getAggregationStrategyMethodName());
                if (this.getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.getStrategyMethodAllowNull());
                    adapter.setAllowNullOldExchange(this.getStrategyMethodAllowNull());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + this.strategyRef);
            }
        }
        if (this.groupExchanges != null && this.groupExchanges.booleanValue()) {
            if (strategy != null || this.strategyRef != null) {
                throw new IllegalArgumentException("Options groupExchanges and AggregationStrategy cannot be enabled at the same time");
            }
            if (this.eagerCheckCompletion != null && !this.eagerCheckCompletion.booleanValue()) {
                throw new IllegalArgumentException("Option eagerCheckCompletion cannot be false when groupExchanges has been enabled");
            }
            this.setEagerCheckCompletion(true);
            strategy = new GroupedExchangeAggregationStrategy();
        }
        if (strategy == null) {
            throw new IllegalArgumentException("AggregationStrategy or AggregationStrategyRef must be set on " + this);
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)strategy)).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }

    private AggregationRepository createAggregationRepository(RouteContext routeContext) {
        AggregationRepository repository = this.getAggregationRepository();
        if (repository == null && this.aggregationRepositoryRef != null) {
            repository = routeContext.mandatoryLookup(this.aggregationRepositoryRef, AggregationRepository.class);
        }
        return repository;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregationStrategyRef() {
        return this.strategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.strategyRef = aggregationStrategyRef;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setAggregationStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public Boolean getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public void setStrategyMethodAllowNull(Boolean strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public Integer getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(Integer completionSize) {
        this.completionSize = completionSize;
    }

    public OptimisticLockRetryPolicyDefinition getOptimisticLockRetryPolicyDefinition() {
        return this.optimisticLockRetryPolicyDefinition;
    }

    public void setOptimisticLockRetryPolicyDefinition(OptimisticLockRetryPolicyDefinition optimisticLockRetryPolicyDefinition) {
        this.optimisticLockRetryPolicyDefinition = optimisticLockRetryPolicyDefinition;
    }

    public OptimisticLockRetryPolicy getOptimisticLockRetryPolicy() {
        return this.optimisticLockRetryPolicy;
    }

    public void setOptimisticLockRetryPolicy(OptimisticLockRetryPolicy optimisticLockRetryPolicy) {
        this.optimisticLockRetryPolicy = optimisticLockRetryPolicy;
    }

    public Long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(Long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public Long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(Long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public ExpressionSubElementDefinition getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(ExpressionSubElementDefinition completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public ExpressionSubElementDefinition getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(ExpressionSubElementDefinition completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public ExpressionSubElementDefinition getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(ExpressionSubElementDefinition completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public Boolean getGroupExchanges() {
        return this.groupExchanges;
    }

    public void setGroupExchanges(Boolean groupExchanges) {
        this.groupExchanges = groupExchanges;
    }

    public Boolean getCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(Boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Boolean getOptimisticLocking() {
        return this.optimisticLocking;
    }

    public void setOptimisticLocking(boolean optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(Boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public Boolean getIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(Boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public String getAggregationRepositoryRef() {
        return this.aggregationRepositoryRef;
    }

    public void setAggregationRepositoryRef(String aggregationRepositoryRef) {
        this.aggregationRepositoryRef = aggregationRepositoryRef;
    }

    public Boolean getDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(Boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public void setTimeoutCheckerExecutorServiceRef(String timeoutCheckerExecutorServiceRef) {
        this.timeoutCheckerExecutorServiceRef = timeoutCheckerExecutorServiceRef;
    }

    public String getTimeoutCheckerExecutorServiceRef() {
        return this.timeoutCheckerExecutorServiceRef;
    }

    public Boolean getForceCompletionOnStop() {
        return this.forceCompletionOnStop;
    }

    public void setForceCompletionOnStop(Boolean forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public AggregateDefinition eagerCheckCompletion() {
        this.setEagerCheckCompletion(true);
        return this;
    }

    public AggregateDefinition ignoreInvalidCorrelationKeys() {
        this.setIgnoreInvalidCorrelationKeys(true);
        return this;
    }

    public AggregateDefinition closeCorrelationKeyOnCompletion(int capacity) {
        this.setCloseCorrelationKeyOnCompletion(capacity);
        return this;
    }

    public AggregateDefinition discardOnCompletionTimeout() {
        this.setDiscardOnCompletionTimeout(true);
        return this;
    }

    public AggregateDefinition completionFromBatchConsumer() {
        this.setCompletionFromBatchConsumer(true);
        return this;
    }

    public AggregateDefinition completionSize(int completionSize) {
        this.setCompletionSize(completionSize);
        return this;
    }

    public AggregateDefinition completionSize(Expression completionSize) {
        this.setCompletionSizeExpression(new ExpressionSubElementDefinition(completionSize));
        return this;
    }

    public AggregateDefinition completionInterval(long completionInterval) {
        this.setCompletionInterval(completionInterval);
        return this;
    }

    public AggregateDefinition completionTimeout(long completionTimeout) {
        this.setCompletionTimeout(completionTimeout);
        return this;
    }

    public AggregateDefinition completionTimeout(Expression completionTimeout) {
        this.setCompletionTimeoutExpression(new ExpressionSubElementDefinition(completionTimeout));
        return this;
    }

    public AggregateDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregateDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public AggregateDefinition aggregationStrategyMethodAllowNull() {
        this.setStrategyMethodAllowNull(true);
        return this;
    }

    public AggregateDefinition aggregationRepository(AggregationRepository aggregationRepository) {
        this.setAggregationRepository(aggregationRepository);
        return this;
    }

    public AggregateDefinition aggregationRepositoryRef(String aggregationRepositoryRef) {
        this.setAggregationRepositoryRef(aggregationRepositoryRef);
        return this;
    }

    @Deprecated
    public AggregateDefinition groupExchanges() {
        this.setGroupExchanges(true);
        this.setEagerCheckCompletion(true);
        return this;
    }

    public AggregateDefinition completionPredicate(Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletionPredicate(new ExpressionSubElementDefinition(predicate));
        return this;
    }

    public AggregateDefinition forceCompletionOnStop() {
        this.setForceCompletionOnStop(true);
        return this;
    }

    public AggregateDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public AggregateDefinition optimisticLocking() {
        this.setOptimisticLocking(true);
        return this;
    }

    public AggregateDefinition optimisticLockRetryPolicy(OptimisticLockRetryPolicy policy) {
        this.setOptimisticLockRetryPolicy(policy);
        return this;
    }

    @Override
    public AggregateDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public AggregateDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorService(ScheduledExecutorService executorService) {
        this.setTimeoutCheckerExecutorService(executorService);
        return this;
    }

    public AggregateDefinition timeoutCheckerExecutorServiceRef(String executorServiceRef) {
        this.setTimeoutCheckerExecutorServiceRef(executorServiceRef);
        return this;
    }

    public ExpressionDefinition getExpression() {
        if (this.expression == null && this.correlationExpression != null) {
            this.expression = this.correlationExpression.getExpressionType();
        }
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletionPredicate() != null) {
            throw new IllegalArgumentException("There is already a completionPredicate defined for this aggregator: " + this);
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }
}

