/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.commands.FindObjectCommand;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.RemoveObjectCommand;
import org.kie.api.command.Command;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.internal.command.Context;

public class JPAExecutorStoreService
implements ExecutorStoreService {
    private EntityManagerFactory emf;
    private CommandService commandService;

    public JPAExecutorStoreService(boolean active) {
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void persistRequest(RequestInfo request) {
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{request}));
    }

    public void updateRequest(RequestInfo request) {
        this.commandService.execute((Command)new MergeObjectCommand(new Object[]{request}));
    }

    public RequestInfo removeRequest(Long requestId) {
        return (RequestInfo)this.commandService.execute((Command)new LockAndCancelRequestInfoCommand(requestId));
    }

    public RequestInfo findRequest(Long id) {
        return (RequestInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, RequestInfo.class));
    }

    public void persistError(ErrorInfo error) {
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{error}));
    }

    public void updateError(ErrorInfo error) {
        this.commandService.execute((Command)new MergeObjectCommand(new Object[]{error}));
    }

    public ErrorInfo removeError(Long errorId) {
        ErrorInfo error = this.findError(errorId);
        this.commandService.execute((Command)new RemoveObjectCommand(new Object[]{error}));
        return error;
    }

    public ErrorInfo findError(Long id) {
        return (ErrorInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, ErrorInfo.class));
    }

    public Runnable buildExecutorRunnable() {
        return ExecutorServiceFactory.buildRunable(this.emf);
    }

    private class LockAndCancelRequestInfoCommand
    implements GenericCommand<RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;
        private Long requestId;

        LockAndCancelRequestInfoCommand(Long requestId) {
            this.requestId = requestId;
        }

        public RequestInfo execute(Context context) {
            HashMap<String, Number> params = new HashMap<String, Number>();
            params.put("id", this.requestId);
            params.put("firstResult", 0);
            params.put("maxResults", 1);
            RequestInfo request = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                request = (RequestInfo)ctx.queryAndLockWithParametersInTransaction("PendingRequestById", params, true, RequestInfo.class);
                if (request != null) {
                    request.setStatus(STATUS.CANCELLED);
                    ctx.merge((Object)request);
                }
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            return request;
        }
    }
}

