/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectInEntryPointCommand
implements GenericCommand<Object>,
IdentifiableResult {
    private FactHandle factHandle;
    private String outIdentifier;
    @XmlAttribute(name="entry-point")
    private String entryPoint;

    public GetObjectInEntryPointCommand() {
    }

    public GetObjectInEntryPointCommand(FactHandle factHandle, String entryPoint) {
        this.factHandle = factHandle;
        this.entryPoint = entryPoint;
    }

    public GetObjectInEntryPointCommand(FactHandle factHandle, String entryPoint, String outIdentifier) {
        this.factHandle = factHandle;
        this.entryPoint = entryPoint;
        this.outIdentifier = outIdentifier;
    }

    @Override
    @XmlAttribute(name="out-identifier", required=true)
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @XmlAttribute(name="fact-handle", required=true)
    public void setFactHandleFromString(String factHandleId) {
        this.factHandle = DefaultFactHandle.createFromExternalFormat(factHandleId);
    }

    public String getFactHandleFromString() {
        return this.factHandle.toExternalForm();
    }

    @Override
    public Object execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        EntryPoint ep = ksession.getEntryPoint(this.entryPoint);
        Object object = ep.getObject(this.factHandle);
        if (this.outIdentifier != null) {
            ((StatefulKnowledgeSessionImpl)ksession).getExecutionResult().getResults().put(this.outIdentifier, object);
        }
        return object;
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    public String toString() {
        return "session.getEntryPoint( " + this.entryPoint + " ).getObject( " + this.factHandle + " );";
    }
}

