/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceImpl;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;

class ProcessDescriptionRepository {
    private Map<String, ProcessDescRepoHelper> processRepoHelperCache = new ConcurrentHashMap<String, ProcessDescRepoHelper>();
    public static ThreadLocal<ProcessDescRepoHelper> LOCAL_PROCESS_REPO_HELPER = new ThreadLocal<ProcessDescRepoHelper>(){

        @Override
        protected ProcessDescRepoHelper initialValue() {
            return new ProcessDescRepoHelper();
        }
    };

    ProcessDescriptionRepository() {
    }

    public ProcessDescRepoHelper getProcessDesc(String processId) {
        return this.processRepoHelperCache.get(processId);
    }

    public void addProcessDescription(String processId, ProcessDescRepoHelper helper) {
        BPMN2DataServiceImpl.useDataServiceExpressionBuilders(helper);
        this.processRepoHelperCache.put(processId, helper);
    }

    public ProcessDescRepoHelper removeProcessDescription(String processId) {
        BPMN2DataServiceImpl.resetDialectExpressionBuilders();
        ProcessDescRepoHelper repoHelper = this.processRepoHelperCache.remove(processId);
        repoHelper.resolveUnqualifiedClasses();
        return repoHelper;
    }
}

