/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.codecs.PerDocProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextPerDocConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextPerDocProducer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.PerDocWriteState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.util.BytesRef;

public class SimpleTextNormsFormat
extends NormsFormat {
    private static final String NORMS_SEG_SUFFIX = "len";

    public PerDocConsumer docsConsumer(PerDocWriteState state) throws IOException {
        return new SimpleTextNormsPerDocConsumer(state);
    }

    public PerDocProducer docsProducer(SegmentReadState state) throws IOException {
        return new SimpleTextNormsPerDocProducer(state, BytesRef.getUTF8SortedAsUnicodeComparator());
    }

    public static class SimpleTextNormsPerDocConsumer
    extends SimpleTextPerDocConsumer {
        public SimpleTextNormsPerDocConsumer(PerDocWriteState state) {
            super(state, SimpleTextNormsFormat.NORMS_SEG_SUFFIX);
        }

        protected DocValues getDocValuesForMerge(AtomicReader reader, FieldInfo info) throws IOException {
            return reader.normValues(info.name);
        }

        protected boolean canMerge(FieldInfo info) {
            return info.hasNorms();
        }

        protected DocValues.Type getDocValuesType(FieldInfo info) {
            return info.getNormType();
        }

        @Override
        public void abort() {
        }
    }

    public static class SimpleTextNormsPerDocProducer
    extends SimpleTextPerDocProducer {
        public SimpleTextNormsPerDocProducer(SegmentReadState state, Comparator<BytesRef> comp) throws IOException {
            super(state, comp, SimpleTextNormsFormat.NORMS_SEG_SUFFIX);
        }

        protected boolean canLoad(FieldInfo info) {
            return info.hasNorms();
        }

        protected DocValues.Type getDocValuesType(FieldInfo info) {
            return info.getNormType();
        }

        protected boolean anyDocValuesFields(FieldInfos infos) {
            return infos.hasNorms();
        }
    }
}

