/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.Context;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;

@XmlRootElement(name="get-tasks-for-process-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetTasksForProcessCommand
extends TaskCommand<List<TaskSummary>>
implements ProcessInstanceIdCommand {
    private static final long serialVersionUID = -3784821014329573243L;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlElement
    private List<Status> statuses;
    @XmlElement(name="language")
    @XmlSchemaType(name="string")
    private String language;

    public GetTasksForProcessCommand() {
    }

    public GetTasksForProcessCommand(Long processInstanceId, List<Status> statuses, String language) {
        this.processInstanceId = processInstanceId;
        this.statuses = statuses;
        this.language = language;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<Status> statuses) {
        this.statuses = statuses;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<TaskSummary> execute(Context context) {
        TaskContext ctx = (TaskContext)context;
        TaskPersistenceContext persistenceContext = ctx.getPersistenceContext();
        List tasks = (List)persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)persistenceContext.addParametersToMap(new Object[]{"processInstanceId", this.processInstanceId, "status", this.statuses}), ClassUtil.castClass(List.class));
        return tasks;
    }
}

