/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.management;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.management.DroolsManagementAgent;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.management.KieSessionMonitoringMBean;

public class KieSessionMonitoringImpl
implements KieSessionMonitoringMBean {
    private static final String KSESSION_PREFIX = "org.drools.kbases";
    private static final long NANO_TO_MILLISEC = 1000000L;
    private InternalWorkingMemory ksession;
    private InternalKnowledgeBase kbase;
    private ObjectName name;
    public AgendaStats agendaStats;
    public ProcessStats processStats;

    public KieSessionMonitoringImpl(InternalWorkingMemory ksession) {
        this.ksession = ksession;
        this.kbase = ksession.getKnowledgeBase();
        this.name = DroolsManagementAgent.createObjectName("org.drools.kbases:type=" + this.kbase.getId() + ",group=Sessions,sessionId=Session-" + ksession.getId());
        this.agendaStats = new AgendaStats();
        this.processStats = new ProcessStats();
        this.ksession.addEventListener(this.agendaStats);
        if (ksession.internalGetProcessRuntime() != null) {
            this.ksession.internalGetProcessRuntime().addEventListener(this.processStats);
        }
    }

    public void dispose() {
        this.ksession.removeEventListener(this.agendaStats);
        if (this.ksession.internalGetProcessRuntime() != null) {
            this.ksession.internalGetProcessRuntime().removeEventListener(this.processStats);
        }
    }

    public void reset() {
        this.agendaStats.reset();
        this.processStats.reset();
    }

    public InternalWorkingMemory getKsession() {
        return this.ksession;
    }

    public InternalKnowledgeBase getKbase() {
        return this.kbase;
    }

    public ObjectName getName() {
        return this.name;
    }

    public String getKieBaseId() {
        return this.kbase.getId();
    }

    public int getKieSessionId() {
        return this.ksession.getId();
    }

    public long getTotalFactCount() {
        return this.ksession.getTotalFactCount();
    }

    public long getTotalMatchesFired() {
        return this.agendaStats.getConsolidatedStats().matchesFired.get();
    }

    public long getTotalMatchesCancelled() {
        return this.agendaStats.getConsolidatedStats().matchesCancelled.get();
    }

    public long getTotalMatchesCreated() {
        return this.agendaStats.getConsolidatedStats().matchesCreated.get();
    }

    public long getTotalFiringTime() {
        return this.agendaStats.getConsolidatedStats().firingTime.get() / 1000000L;
    }

    public Date getLastReset() {
        return this.agendaStats.getConsolidatedStats().lastReset.get();
    }

    public double getAverageFiringTime() {
        long fires = this.agendaStats.getConsolidatedStats().matchesFired.get();
        long time = this.agendaStats.getConsolidatedStats().firingTime.get();
        return fires > 0L ? (double)time / (double)fires / 1000000.0 : 0.0;
    }

    public String getStatsForRule(String ruleName) {
        AgendaStats.AgendaStatsData data = this.agendaStats.getRuleStats(ruleName);
        String result = data == null ? "matchesCreated=0 matchesCancelled=0 matchesFired=0 firingTime=0ms" : data.toString();
        return result;
    }

    public Map<String, String> getStatsByRule() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, AgendaStats.AgendaStatsData> entry : this.agendaStats.getRulesStats().entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public long getTotalProcessInstancesStarted() {
        return this.processStats.getConsolidatedStats().processInstancesStarted.get();
    }

    public long getTotalProcessInstancesCompleted() {
        return this.processStats.getConsolidatedStats().processInstancesCompleted.get();
    }

    public String getStatsForProcess(String processId) {
        ProcessStats.ProcessStatsData data = this.processStats.getProcessStats(processId);
        String result = data == null ? "processInstancesStarted=0 processInstancesCompleted=0 processNodesTriggered=0" : data.toString();
        return result;
    }

    public Map<String, String> getStatsByProcess() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ProcessStats.ProcessStatsData> entry : this.processStats.getProcessStats().entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public String getStatsForProcessInstance(long processInstanceId) {
        ProcessStats.ProcessInstanceStatsData data = this.processStats.getProcessInstanceStats(processInstanceId);
        String result = data == null ? "Process instance not found" : data.toString();
        return result;
    }

    public Map<Long, String> getStatsByProcessInstance() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        for (Map.Entry<Long, ProcessStats.ProcessInstanceStatsData> entry : this.processStats.getProcessInstanceStats().entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public static class ProcessStats
    implements ProcessEventListener {
        private GlobalProcessStatsData consolidated = new GlobalProcessStatsData();
        private ConcurrentHashMap<String, ProcessStatsData> processStats = new ConcurrentHashMap();
        private ConcurrentHashMap<Long, ProcessInstanceStatsData> processInstanceStats = new ConcurrentHashMap();

        public GlobalProcessStatsData getConsolidatedStats() {
            return this.consolidated;
        }

        public Map<String, ProcessStatsData> getProcessStats() {
            return this.processStats;
        }

        public ProcessStatsData getProcessStats(String processId) {
            return this.processStats.get(processId);
        }

        public Map<Long, ProcessInstanceStatsData> getProcessInstanceStats() {
            return this.processInstanceStats;
        }

        public ProcessInstanceStatsData getProcessInstanceStats(Long processInstanceId) {
            return this.processInstanceStats.get(processInstanceId);
        }

        public void reset() {
            this.consolidated.reset();
            this.processStats.clear();
            this.processInstanceStats.clear();
        }

        private ProcessStatsData getProcessStatsInstance(String processId) {
            ProcessStatsData data = this.processStats.get(processId);
            if (data == null) {
                data = new ProcessStatsData();
                this.processStats.put(processId, data);
            }
            return data;
        }

        private ProcessInstanceStatsData getProcessInstanceStatsInstance(Long processInstanceId) {
            ProcessInstanceStatsData data = this.processInstanceStats.get(processInstanceId);
            if (data == null) {
                data = new ProcessInstanceStatsData();
                this.processInstanceStats.put(processInstanceId, data);
            }
            return data;
        }

        public void afterProcessStarted(ProcessStartedEvent event) {
            this.consolidated.processInstancesStarted.incrementAndGet();
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processInstancesStarted.incrementAndGet();
            ProcessInstanceStatsData dataI = this.getProcessInstanceStatsInstance(event.getProcessInstance().getId());
            dataI.processStarted = new Date();
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            this.consolidated.processInstancesCompleted.incrementAndGet();
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processInstancesCompleted.incrementAndGet();
            ProcessInstanceStatsData dataI = this.getProcessInstanceStatsInstance(event.getProcessInstance().getId());
            dataI.processCompleted = new Date();
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            ProcessStatsData data = this.getProcessStatsInstance(event.getProcessInstance().getProcessId());
            data.processNodesTriggered.incrementAndGet();
            ProcessInstanceStatsData dataI = this.getProcessInstanceStatsInstance(event.getProcessInstance().getId());
            ++dataI.processNodesTriggered;
        }

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void beforeProcessCompleted(ProcessCompletedEvent event) {
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
        }

        public void afterVariableChanged(ProcessVariableChangedEvent event) {
        }

        public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        }

        public static class ProcessInstanceStatsData {
            public Date processStarted;
            public Date processCompleted;
            public long processNodesTriggered = 0L;

            public void reset() {
                this.processNodesTriggered = 0L;
            }

            public String toString() {
                return (this.processStarted != null ? "processStarted=" + this.processStarted + " " : "") + (this.processCompleted != null ? "processCompleted=" + this.processCompleted + " " : "") + "processNodesTriggered=" + this.processNodesTriggered;
            }
        }

        public static class ProcessStatsData
        extends GlobalProcessStatsData {
            public AtomicLong processNodesTriggered = new AtomicLong(0L);

            @Override
            public void reset() {
                super.reset();
                this.processNodesTriggered.set(0L);
            }

            @Override
            public String toString() {
                return super.toString() + " processNodesTriggered=" + this.processNodesTriggered.get();
            }
        }

        public static class GlobalProcessStatsData {
            public AtomicLong processInstancesStarted = new AtomicLong(0L);
            public AtomicLong processInstancesCompleted = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());

            public void reset() {
                this.processInstancesStarted.set(0L);
                this.processInstancesCompleted.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "processInstancesStarted=" + this.processInstancesStarted.get() + " processInstancesCompleted=" + this.processInstancesCompleted.get();
            }
        }
    }

    public static class AgendaStats
    implements AgendaEventListener {
        private AgendaStatsData consolidated = new AgendaStatsData();
        private ConcurrentHashMap<String, AgendaStatsData> ruleStats = new ConcurrentHashMap();

        public AgendaStatsData getConsolidatedStats() {
            return this.consolidated;
        }

        public Map<String, AgendaStatsData> getRulesStats() {
            return this.ruleStats;
        }

        public AgendaStatsData getRuleStats(String ruleName) {
            return this.ruleStats.get(ruleName);
        }

        public void reset() {
            this.consolidated.reset();
            this.ruleStats.clear();
        }

        public void matchCancelled(MatchCancelledEvent event) {
            this.consolidated.matchesCancelled.incrementAndGet();
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            data.matchesCancelled.incrementAndGet();
        }

        public void matchCreated(MatchCreatedEvent event) {
            this.consolidated.matchesCreated.incrementAndGet();
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            data.matchesCreated.incrementAndGet();
        }

        public void afterMatchFired(AfterMatchFiredEvent event) {
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            this.consolidated.stopFireClock();
            data.stopFireClock();
            this.consolidated.matchesFired.incrementAndGet();
            data.matchesFired.incrementAndGet();
        }

        public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
        }

        public void agendaGroupPushed(AgendaGroupPushedEvent event) {
        }

        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        }

        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        }

        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        }

        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        }

        public void beforeMatchFired(BeforeMatchFiredEvent event) {
            AgendaStatsData data = this.getRuleStatsInstance(event.getMatch().getRule().getName());
            this.consolidated.startFireClock();
            data.startFireClock();
        }

        private AgendaStatsData getRuleStatsInstance(String ruleName) {
            AgendaStatsData data = this.ruleStats.get(ruleName);
            if (data == null) {
                data = new AgendaStatsData();
                this.ruleStats.put(ruleName, data);
            }
            return data;
        }

        public static class AgendaStatsData {
            public AtomicLong matchesFired = new AtomicLong(0L);
            public AtomicLong matchesCreated = new AtomicLong(0L);
            public AtomicLong matchesCancelled = new AtomicLong(0L);
            public AtomicLong firingTime = new AtomicLong(0L);
            public AtomicReference<Date> lastReset = new AtomicReference<Date>(new Date());
            public long start;

            public void startFireClock() {
                this.start = System.nanoTime();
            }

            public void stopFireClock() {
                this.firingTime.addAndGet(System.nanoTime() - this.start);
            }

            public void reset() {
                this.matchesFired.set(0L);
                this.matchesCreated.set(0L);
                this.matchesCancelled.set(0L);
                this.firingTime.set(0L);
                this.lastReset.set(new Date());
            }

            public String toString() {
                return "matchesCreated=" + this.matchesCreated.get() + " matchesCancelled=" + this.matchesCancelled.get() + " matchesFired=" + this.matchesFired.get() + " firingTime=" + this.firingTime.get() / 1000000L + "ms";
            }
        }
    }
}

