/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEndpointRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed EndpointRegistry")
public class ManagedEndpointRegistry
extends ManagedService
implements ManagedEndpointRegistryMBean {
    private final EndpointRegistry endpointRegistry;

    public ManagedEndpointRegistry(CamelContext context, EndpointRegistry endpointRegistry) {
        super(context, endpointRegistry);
        this.endpointRegistry = endpointRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    @Override
    public String getSource() {
        return this.endpointRegistry.toString();
    }

    @Override
    public Integer getDynamicSize() {
        return this.endpointRegistry.dynamicSize();
    }

    @Override
    public Integer getStaticSize() {
        return this.endpointRegistry.staticSize();
    }

    @Override
    public Integer getSize() {
        return this.endpointRegistry.size();
    }

    @Override
    public Integer getMaximumCacheSize() {
        return this.endpointRegistry.getMaximumCacheSize();
    }

    @Override
    public void purge() {
        this.endpointRegistry.purge();
    }

    @Override
    public TabularData listEndpoints() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listEndpointsTabularType());
            Collection endpoints = this.endpointRegistry.values();
            for (Endpoint endpoint : endpoints) {
                CompositeType ct = CamelOpenMBeanTypes.listEndpointsCompositeType();
                String url = endpoint.getEndpointUri();
                boolean fromStatic = this.endpointRegistry.isStatic(url);
                boolean fromDynamic = this.endpointRegistry.isDynamic(url);
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "static", "dynamic"}, new Object[]{url, fromStatic, fromDynamic});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

