/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.List;
import java.util.Map;
import org.drools.core.time.TimerService;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerFactory;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.api.SchedulerProvider;
import org.jbpm.runtime.manager.impl.CacheManagerImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.CacheManager;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.SecurityManager;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;

public abstract class AbstractRuntimeManager
implements InternalRuntimeManager {
    protected RuntimeManagerRegistry registry = RuntimeManagerRegistry.get();
    protected RuntimeEnvironment environment;
    protected DeploymentDescriptor deploymentDescriptor;
    protected KieContainer kieContainer;
    protected CacheManager cacheManager = new CacheManagerImpl();
    protected boolean engineInitEager = Boolean.parseBoolean(System.getProperty("org.jbpm.rm.engine.eager", "false"));
    protected String identifier;
    protected boolean closed = false;
    protected SecurityManager securityManager = null;

    public AbstractRuntimeManager(RuntimeEnvironment environment, String identifier) {
        this.environment = environment;
        this.identifier = identifier;
        if (this.registry.isRegistered(identifier)) {
            throw new IllegalStateException("RuntimeManager with id " + identifier + " is already active");
        }
        this.internalSetDeploymentDescriptor();
        this.internalSetKieContainer();
        ((InternalRegisterableItemsFactory)environment.getRegisterableItemsFactory()).setRuntimeManager((InternalRuntimeManager)this);
        String eagerInit = (String)((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().get("RuntimeEngineEagerInit");
        if (eagerInit != null) {
            this.engineInitEager = Boolean.parseBoolean(eagerInit);
        }
    }

    private void internalSetDeploymentDescriptor() {
        this.deploymentDescriptor = (DeploymentDescriptor)((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("KieDeploymentDescriptor");
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = new DeploymentDescriptorManager().getDefaultDescriptor();
        }
    }

    private void internalSetKieContainer() {
        this.kieContainer = (KieContainer)((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("KieContainer");
    }

    public abstract void init();

    protected void registerItems(RuntimeEngine runtime) {
        RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
        Map handlers = factory.getWorkItemHandlers(runtime);
        for (Map.Entry entry : handlers.entrySet()) {
            runtime.getKieSession().getWorkItemManager().registerWorkItemHandler((String)entry.getKey(), (WorkItemHandler)entry.getValue());
        }
        Map globals = factory.getGlobals(runtime);
        for (Map.Entry entry : globals.entrySet()) {
            runtime.getKieSession().setGlobal((String)entry.getKey(), entry.getValue());
        }
        List processListeners = factory.getProcessEventListeners(runtime);
        for (ProcessEventListener listener : processListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
        List agendaListeners = factory.getAgendaEventListeners(runtime);
        for (AgendaEventListener listener : agendaListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
        List wmListeners = factory.getRuleRuntimeEventListeners(runtime);
        for (RuleRuntimeEventListener listener : wmListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
    }

    protected void registerDisposeCallback(RuntimeEngine runtime, TransactionSynchronization sync) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
            return;
        }
        TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
        if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)((OrderedTransactionSynchronization)sync));
        }
    }

    protected boolean canDispose(RuntimeEngine runtime) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
            return true;
        }
        TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
        return tm.getStatus() == 3 || tm.getStatus() == 1 || tm.getStatus() == 0;
    }

    protected void attachManager(RuntimeEngine runtime) {
        runtime.getKieSession().getEnvironment().set("RuntimeManager", (Object)this);
        runtime.getKieSession().getEnvironment().set("deploymentId", (Object)this.getIdentifier());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean removeJobs) {
        this.cacheManager.dispose();
        this.environment.close();
        this.registry.remove(this.identifier);
        TimerService timerService = TimerServiceRegistry.getInstance().remove(this.getIdentifier() + "-timerServiceId");
        if (timerService != null) {
            if (removeJobs && timerService instanceof GlobalTimerService) {
                ((GlobalTimerService)timerService).destroy();
            }
            timerService.shutdown();
            GlobalSchedulerService schedulerService = ((SchedulerProvider)this.environment).getSchedulerService();
            if (schedulerService != null) {
                schedulerService.shutdown();
            }
        }
        this.closed = true;
    }

    public org.kie.internal.runtime.manager.RuntimeEnvironment getEnvironment() {
        return (org.kie.internal.runtime.manager.RuntimeEnvironment)this.environment;
    }

    public void setEnvironment(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void configureRuntimeOnTaskService(InternalTaskService internalTaskService, RuntimeEngine engine) {
        if (internalTaskService != null) {
            ExternalTaskEventListener listener = new ExternalTaskEventListener();
            if (internalTaskService instanceof EventService) {
                ((EventService)internalTaskService).registerTaskEventListener((Object)listener);
            }
            RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
            for (TaskLifeCycleEventListener taskListener : factory.getTaskListeners()) {
                ((EventService)internalTaskService).registerTaskEventListener((Object)taskListener);
            }
            if (engine != null && engine instanceof Disposable) {
                ((Disposable)engine).addDisposeListener(new DisposeListener(){

                    public void onDispose(RuntimeEngine runtime) {
                        if (runtime.getTaskService() instanceof EventService) {
                            ((EventService)runtime.getTaskService()).clearTaskEventListeners();
                        }
                    }
                });
            }
        }
    }

    protected void removeRuntimeFromTaskService() {
        TaskContentRegistry.get().removeMarshallerContext(this.getIdentifier());
    }

    protected boolean canDestroy(RuntimeEngine runtime) {
        if (this.hasEnvironmentEntry("IS_JTA_TRANSACTION", false) || ((RuntimeEngineImpl)runtime).isAfterCompletion()) {
            return false;
        }
        TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
        return tm.getStatus() == 3 || tm.getStatus() == 4;
    }

    protected boolean hasEnvironmentEntry(String name, Object value) {
        Object envEntry = this.environment.getEnvironment().get(name);
        if (value == null) {
            return envEntry == null;
        }
        return value.equals(envEntry);
    }

    protected TransactionManager getTransactionManager(Environment env) {
        Object txm;
        if (env == null) {
            env = this.environment.getEnvironment();
        }
        if ((txm = env.get("org.kie.transaction.TransactionManager")) != null && txm instanceof TransactionManager) {
            return (TransactionManager)txm;
        }
        return TransactionManagerFactory.get().newTransactionManager();
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        if (this.securityManager != null) {
            throw new IllegalStateException("Security Manager for " + this.identifier + " manager is already set");
        }
        this.securityManager = securityManager;
    }

    protected void checkPermission() {
        if (this.securityManager != null) {
            this.securityManager.checkPermission();
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        if (cacheManager != null) {
            this.cacheManager = cacheManager;
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(KieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }
}

