/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl.audit;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;
import org.kie.services.client.serialization.jaxb.impl.audit.AbstractJaxbHistoryObject;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbNodeInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;

@XmlRootElement(name="log-instance-list")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbHistoryLogList
implements JaxbCommandResponse<List<Object>>,
JaxbPaginatedList<Object> {
    @XmlElements(value={@XmlElement(name="process-instance-log", type=JaxbProcessInstanceLog.class), @XmlElement(name="node-instance-log", type=JaxbNodeInstanceLog.class), @XmlElement(name="variable-instance-log", type=JaxbVariableInstanceLog.class)})
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=JaxbProcessInstanceLog.class), @JsonSubTypes.Type(value=JaxbNodeInstanceLog.class), @JsonSubTypes.Type(value=JaxbVariableInstanceLog.class)})
    private List<AbstractJaxbHistoryObject> historyLogList;
    @XmlAttribute
    @XmlSchemaType(name="int")
    private Integer index;
    @XmlElement(name="command-name")
    @XmlSchemaType(name="string")
    private String commandName;
    @XmlElement(name="page-number")
    @XmlSchemaType(name="int")
    private Integer pageNumber;
    @XmlElement(name="page-size")
    @XmlSchemaType(name="int")
    private Integer pageSize;

    public JaxbHistoryLogList() {
    }

    public JaxbHistoryLogList(List<? extends Object> logList) {
        this.initialize(logList);
    }

    private void initialize(List<? extends Object> logList) {
        this.historyLogList = new ArrayList<AbstractJaxbHistoryObject>();
        if (logList == null || logList.size() == 0) {
            return;
        }
        for (Object object : logList) {
            if (object instanceof ProcessInstanceLog) {
                this.historyLogList.add(new JaxbProcessInstanceLog((ProcessInstanceLog)object));
                continue;
            }
            if (object instanceof NodeInstanceLog) {
                this.historyLogList.add(new JaxbNodeInstanceLog((NodeInstanceLog)object));
                continue;
            }
            if (object instanceof VariableInstanceLog) {
                this.historyLogList.add(new JaxbVariableInstanceLog((VariableInstanceLog)object));
                continue;
            }
            throw new IllegalArgumentException(object.getClass().getSimpleName() + " is not an acceptable object (list) for this constructor.");
        }
    }

    public List<AbstractJaxbHistoryObject> getHistoryLogList() {
        this.lazyInitResponseList();
        return this.historyLogList;
    }

    public void setHistoryLogList(List<AbstractJaxbHistoryObject> list) {
        this.historyLogList = list;
    }

    private void lazyInitResponseList() {
        if (this.historyLogList == null) {
            this.historyLogList = new ArrayList<AbstractJaxbHistoryObject>();
        }
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    @JsonIgnore
    public List<Object> getResult() {
        this.lazyInitResponseList();
        ArrayList<Object> results = new ArrayList<Object>();
        for (AbstractJaxbHistoryObject jaxbHistLog : this.historyLogList) {
            results.add(jaxbHistLog);
        }
        return results;
    }

    @Override
    public void setResult(List<Object> result) {
        this.initialize(result);
    }

    @Override
    public void addContents(List<Object> contentList) {
        this.initialize(contentList);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=JaxbProcessInstanceLog.class), @JsonSubTypes.Type(value=JaxbNodeInstanceLog.class), @JsonSubTypes.Type(value=JaxbVariableInstanceLog.class)})
    public List<AbstractJaxbHistoryObject> getList() {
        return this.historyLogList;
    }

    public void setList(List<AbstractJaxbHistoryObject> historyLogList) {
        this.historyLogList = historyLogList;
    }

    @Override
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public void setPageNumber(Integer page) {
        this.pageNumber = page;
    }

    @Override
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

