/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.JaxbSerializationProvider;

@XmlRootElement(name="process-instance")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbProcessInstance
implements ProcessInstance {
    @XmlElement(name="process-id")
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement
    @XmlSchemaType(name="long")
    private long id;
    @XmlElement
    @XmlSchemaType(name="int")
    private int state;
    @XmlElement(name="event-types")
    private List<String> eventTypes = new ArrayList<String>();
    @XmlElement
    @XmlSchemaType(name="long")
    private long parentProcessInstanceId;

    public JaxbProcessInstance() {
    }

    public JaxbProcessInstance(ProcessInstance processInstance) {
        this.initialize(processInstance);
    }

    public JaxbProcessInstance(ProcessInstanceLog processInstanceLog) {
        if (processInstanceLog != null) {
            this.id = processInstanceLog.getProcessInstanceId();
            this.processId = processInstanceLog.getProcessId();
            this.state = processInstanceLog.getStatus();
            if (processInstanceLog.getParentProcessInstanceId() != null) {
                this.parentProcessInstanceId = processInstanceLog.getParentProcessInstanceId();
            }
        }
    }

    protected void initialize(ProcessInstance processInstance) {
        if (processInstance != null) {
            this.eventTypes = Arrays.asList(processInstance.getEventTypes());
            this.id = processInstance.getId();
            this.processId = processInstance.getProcessId();
            this.state = processInstance.getState();
        }
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String getProcessName() {
        return JaxbSerializationProvider.unsupported(ProcessInstance.class, String.class);
    }

    public Process getProcess() {
        return JaxbSerializationProvider.unsupported(ProcessInstance.class, Process.class);
    }

    public String[] getEventTypes() {
        return this.eventTypes.toArray(new String[this.eventTypes.size()]);
    }

    public void signalEvent(String type, Object event) {
        JaxbSerializationProvider.unsupported(ProcessInstance.class, Void.class);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProcessInstance ");
        b.append(this.id);
        b.append(" [processId=");
        b.append(this.processId);
        b.append(",state=");
        b.append(this.state);
        b.append("]");
        return b.toString();
    }
}

