/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.usermodel.Background;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.ShapeContainer;

public class DrawBackground
extends DrawShape {
    public DrawBackground(Background<?, ?> shape) {
        super(shape);
    }

    @Override
    public void draw(Graphics2D graphics) {
        Dimension pg = this.shape.getSheet().getSlideShow().getPageSize();
        final Rectangle anchor = new Rectangle(0, 0, (int)pg.getWidth(), (int)pg.getHeight());
        PlaceableShape ps = new PlaceableShape(){

            public ShapeContainer<?, ?> getParent() {
                return null;
            }

            @Override
            public Rectangle getAnchor() {
                return anchor;
            }

            @Override
            public void setAnchor(Rectangle newAnchor) {
            }

            @Override
            public double getRotation() {
                return 0.0;
            }

            @Override
            public void setRotation(double theta) {
            }

            @Override
            public void setFlipHorizontal(boolean flip) {
            }

            @Override
            public void setFlipVertical(boolean flip) {
            }

            @Override
            public boolean getFlipHorizontal() {
                return false;
            }

            @Override
            public boolean getFlipVertical() {
                return false;
            }
        };
        DrawFactory drawFact = DrawFactory.getInstance(graphics);
        DrawPaint dp = drawFact.getPaint(ps);
        Paint fill = dp.getPaint(graphics, this.getShape().getFillStyle().getPaint());
        Rectangle2D anchor2 = DrawBackground.getAnchor(graphics, anchor);
        if (fill != null) {
            graphics.setPaint(fill);
            graphics.fill(anchor2);
        }
    }

    protected Background<?, ?> getShape() {
        return (Background)this.shape;
    }
}

