/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.command;

import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.command.CommandService;
import org.jbpm.services.task.commands.ActivateTaskCommand;
import org.jbpm.services.task.commands.AddAttachmentCommand;
import org.jbpm.services.task.commands.AddCommentCommand;
import org.jbpm.services.task.commands.AddContentCommand;
import org.jbpm.services.task.commands.AddContentFromUserCommand;
import org.jbpm.services.task.commands.AddGroupCommand;
import org.jbpm.services.task.commands.AddTaskCommand;
import org.jbpm.services.task.commands.AddUserCommand;
import org.jbpm.services.task.commands.AddUsersGroupsCommand;
import org.jbpm.services.task.commands.ArchiveTasksCommand;
import org.jbpm.services.task.commands.CancelDeadlineCommand;
import org.jbpm.services.task.commands.ClaimNextAvailableTaskCommand;
import org.jbpm.services.task.commands.ClaimTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.CompositeCommand;
import org.jbpm.services.task.commands.DelegateTaskCommand;
import org.jbpm.services.task.commands.DeleteAttachmentCommand;
import org.jbpm.services.task.commands.DeleteCommentCommand;
import org.jbpm.services.task.commands.DeleteContentCommand;
import org.jbpm.services.task.commands.DeleteFaultCommand;
import org.jbpm.services.task.commands.DeleteOutputCommand;
import org.jbpm.services.task.commands.DeployTaskDefCommand;
import org.jbpm.services.task.commands.ExecuteReminderCommand;
import org.jbpm.services.task.commands.ExitTaskCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.ForwardTaskCommand;
import org.jbpm.services.task.commands.GetActiveTasksCommand;
import org.jbpm.services.task.commands.GetAllAttachmentsCommand;
import org.jbpm.services.task.commands.GetAllCommentsCommand;
import org.jbpm.services.task.commands.GetAllContentCommand;
import org.jbpm.services.task.commands.GetAllTaskDefinitionsCommand;
import org.jbpm.services.task.commands.GetArchivedTasksCommand;
import org.jbpm.services.task.commands.GetAttachmentCommand;
import org.jbpm.services.task.commands.GetCommentCommand;
import org.jbpm.services.task.commands.GetCompletedTasksByUserCommand;
import org.jbpm.services.task.commands.GetCompletedTasksCommand;
import org.jbpm.services.task.commands.GetContentByIdCommand;
import org.jbpm.services.task.commands.GetContentByIdForUserCommand;
import org.jbpm.services.task.commands.GetContentMapForUserCommand;
import org.jbpm.services.task.commands.GetGroupCommand;
import org.jbpm.services.task.commands.GetGroupsCommand;
import org.jbpm.services.task.commands.GetOrgEntityCommand;
import org.jbpm.services.task.commands.GetPendingSubTasksCommand;
import org.jbpm.services.task.commands.GetPendingTasksByUserCommand;
import org.jbpm.services.task.commands.GetPotentialOwnersForTaskCommand;
import org.jbpm.services.task.commands.GetSubTasksCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsBusinessAdminCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsExcludedOwnerCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsInitiatorCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsPotentialOwnerCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsRecipientCommand;
import org.jbpm.services.task.commands.GetTaskAssignedAsStakeholderCommand;
import org.jbpm.services.task.commands.GetTaskAssignedByGroupsCommand;
import org.jbpm.services.task.commands.GetTaskByWorkItemIdCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTaskContentCommand;
import org.jbpm.services.task.commands.GetTaskDefinitionCommand;
import org.jbpm.services.task.commands.GetTaskOwnedByExpDateBeforeDateCommand;
import org.jbpm.services.task.commands.GetTaskPropertyCommand;
import org.jbpm.services.task.commands.GetTasksByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.GetTasksByStatusByProcessInstanceIdCommand;
import org.jbpm.services.task.commands.GetTasksByVariousFieldsCommand;
import org.jbpm.services.task.commands.GetTasksOwnedCommand;
import org.jbpm.services.task.commands.GetUserCommand;
import org.jbpm.services.task.commands.GetUserInfoCommand;
import org.jbpm.services.task.commands.GetUsersCommand;
import org.jbpm.services.task.commands.NominateTaskCommand;
import org.jbpm.services.task.commands.ProcessSubTaskCommand;
import org.jbpm.services.task.commands.ReleaseTaskCommand;
import org.jbpm.services.task.commands.RemoveAllTasksCommand;
import org.jbpm.services.task.commands.RemoveGroupCommand;
import org.jbpm.services.task.commands.RemoveTaskCommand;
import org.jbpm.services.task.commands.RemoveTasksCommand;
import org.jbpm.services.task.commands.RemoveUserCommand;
import org.jbpm.services.task.commands.ResumeTaskCommand;
import org.jbpm.services.task.commands.SetTaskPropertyCommand;
import org.jbpm.services.task.commands.SkipTaskCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.jbpm.services.task.commands.StopTaskCommand;
import org.jbpm.services.task.commands.SuspendTaskCommand;
import org.jbpm.services.task.commands.UndeployTaskDefCommand;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.impl.TaskSummaryQueryBuilderImpl;
import org.kie.api.command.Command;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.kie.internal.task.api.model.TaskDef;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;

public class CommandBasedTaskService
implements InternalTaskService,
EventService<TaskLifeCycleEventListener> {
    private CommandService executor;
    private TaskEventSupport taskEventSupport;

    private QueryFilter addLanguageFilter(String language) {
        if (language == null) {
            return null;
        }
        QueryFilter filter = new QueryFilter();
        filter.setCount(null);
        filter.setOffset(null);
        filter.setLanguage(language);
        return filter;
    }

    public CommandBasedTaskService(CommandService executor, TaskEventSupport taskEventSupport) {
        this.executor = executor;
        this.taskEventSupport = taskEventSupport;
    }

    public <T> T execute(Command<T> command) {
        return (T)this.executor.execute(command);
    }

    public void activate(long taskId, String userId) {
        this.executor.execute((Command)new ActivateTaskCommand(taskId, userId));
    }

    public void claim(long taskId, String userId) {
        this.executor.execute((Command)new ClaimTaskCommand(taskId, userId));
    }

    public void claimNextAvailable(String userId, String language) {
        this.executor.execute((Command)new ClaimNextAvailableTaskCommand(userId));
    }

    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.executor.execute(new CompositeCommand<Void>(new CompleteTaskCommand(taskId, userId, data), new ProcessSubTaskCommand(taskId, userId, data), new CancelDeadlineCommand(taskId, true, true)));
    }

    public void delegate(long taskId, String userId, String targetUserId) {
        this.executor.execute((Command)new DelegateTaskCommand(taskId, userId, targetUserId));
    }

    public void exit(long taskId, String userId) {
        this.executor.execute(new CompositeCommand<Void>(new ExitTaskCommand(taskId, userId), new CancelDeadlineCommand(taskId, true, true)));
    }

    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.executor.execute(new CompositeCommand<Void>(new FailTaskCommand(taskId, userId, faultData), new CancelDeadlineCommand(taskId, true, true)));
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.executor.execute((Command)new ForwardTaskCommand(taskId, userId, targetEntityId));
    }

    public Task getTaskByWorkItemId(long workItemId) {
        return (Task)this.executor.execute((Command)new GetTaskByWorkItemIdCommand(workItemId));
    }

    public Task getTaskById(long taskId) {
        return (Task)this.executor.execute((Command)new GetTaskCommand(taskId));
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsBusinessAdminCommand(userId));
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministratorByStatus(String userId, String language, List<Status> statuses) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsBusinessAdminCommand(userId, statuses));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        QueryFilter filter = this.addLanguageFilter(language);
        return this.getTasksAssignedAsPotentialOwner(userId, null, null, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds) {
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, null, null);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsPotentialOwnerCommand(userId, groupIds, status, filter));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        QueryFilter filter = this.addLanguageFilter(language);
        return this.getTasksAssignedAsPotentialOwner(userId, null, status, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<Status> statuses, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksAssignedAsPotentialOwner(userId, null, statuses, new QueryFilter("t.taskData.expirationTime = :expirationDate", params, "t.id", false));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> statuses, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksAssignedAsPotentialOwner(userId, null, statuses, new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "t.id", false));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResults) {
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, null, new QueryFilter(firstResult, maxResults));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status) {
        return this.getTasksAssignedAsPotentialOwner(userId, groupIds, status, null);
    }

    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, QueryFilter filter) {
        return (List)this.executor.execute((Command)new GetTasksOwnedCommand(userId, status, filter));
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        QueryFilter filter = this.addLanguageFilter(language);
        return this.getTasksOwned(userId, null, filter);
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status, String language) {
        QueryFilter filter = this.addLanguageFilter(language);
        return this.getTasksOwned(userId, status, filter);
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(long processInstanceId, List<Status> status, String language) {
        return (List)this.executor.execute((Command)new GetTasksByStatusByProcessInstanceIdCommand(processInstanceId, status));
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        return (List)this.executor.execute((Command)new GetTasksByProcessInstanceIdCommand(processInstanceId));
    }

    @Deprecated
    public List<TaskSummary> getTasksByVariousFields(String userId, List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, List<String> languages, boolean union) {
        GetTasksByVariousFieldsCommand cmd = new GetTasksByVariousFieldsCommand(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, union);
        cmd.setUserId(userId);
        return (List)this.executor.execute((Command)cmd);
    }

    @Deprecated
    public List<TaskSummary> getTasksByVariousFields(String userId, Map<String, List<?>> parameters, boolean union) {
        GetTasksByVariousFieldsCommand cmd = new GetTasksByVariousFieldsCommand(parameters, union);
        cmd.setUserId(userId);
        return (List)this.executor.execute((Command)cmd);
    }

    public TaskSummaryQueryBuilder taskSummaryQuery(String userId) {
        return new TaskSummaryQueryBuilderImpl(userId, (TaskService)this);
    }

    public long addTask(Task task, Map<String, Object> params) {
        return (Long)this.executor.execute((Command)new AddTaskCommand(task, params));
    }

    public void release(long taskId, String userId) {
        this.executor.execute((Command)new ReleaseTaskCommand(taskId, userId));
    }

    public void resume(long taskId, String userId) {
        this.executor.execute((Command)new ResumeTaskCommand(taskId, userId));
    }

    public void skip(long taskId, String userId) {
        this.executor.execute(new CompositeCommand<Void>(new SkipTaskCommand(taskId, userId), new ProcessSubTaskCommand(taskId, userId), new CancelDeadlineCommand(taskId, true, true)));
    }

    public void start(long taskId, String userId) {
        this.executor.execute(new CompositeCommand<Void>(new StartTaskCommand(taskId, userId), new CancelDeadlineCommand(taskId, true, false)));
    }

    public void stop(long taskId, String userId) {
        this.executor.execute((Command)new StopTaskCommand(taskId, userId));
    }

    public void suspend(long taskId, String userId) {
        this.executor.execute((Command)new SuspendTaskCommand(taskId, userId));
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.executor.execute((Command)new NominateTaskCommand(taskId, userId, potentialOwners));
    }

    public Content getContentById(long contentId) {
        return (Content)this.executor.execute((Command)new GetContentByIdCommand(contentId));
    }

    public Attachment getAttachmentById(long attachId) {
        return (Attachment)this.executor.execute((Command)new GetAttachmentCommand(attachId));
    }

    public void addGroup(Group group) {
        this.executor.execute((Command)new AddGroupCommand(group.getId()));
    }

    public void addUser(User user) {
        this.executor.execute((Command)new AddUserCommand(user.getId()));
    }

    public int archiveTasks(List<TaskSummary> tasks) {
        return (Integer)this.executor.execute((Command)new ArchiveTasksCommand(tasks));
    }

    public void claim(long taskId, String userId, List<String> groupIds) {
        this.executor.execute((Command)new ClaimTaskCommand(taskId, userId));
    }

    public void claimNextAvailable(String userId, List<String> groupIds) {
        this.executor.execute((Command)new ClaimNextAvailableTaskCommand(userId));
    }

    public void deleteFault(long taskId, String userId) {
        this.executor.execute((Command)new DeleteFaultCommand(taskId, userId));
    }

    public void deleteOutput(long taskId, String userId) {
        this.executor.execute((Command)new DeleteOutputCommand(taskId, userId));
    }

    public void deployTaskDef(TaskDef def) {
        this.executor.execute((Command)new DeployTaskDefCommand(def));
    }

    public List<TaskSummary> getActiveTasks() {
        return (List)this.executor.execute((Command)new GetActiveTasksCommand());
    }

    public List<TaskSummary> getActiveTasks(Date since) {
        return (List)this.executor.execute((Command)new GetActiveTasksCommand(since));
    }

    public List<TaskDef> getAllTaskDef(String filter) {
        return (List)this.executor.execute((Command)new GetAllTaskDefinitionsCommand(filter));
    }

    public List<TaskSummary> getArchivedTasks() {
        return (List)this.executor.execute((Command)new GetArchivedTasksCommand());
    }

    public List<TaskSummary> getCompletedTasks() {
        return (List)this.executor.execute((Command)new GetCompletedTasksCommand());
    }

    public List<TaskSummary> getCompletedTasks(Date since) {
        return (List)this.executor.execute((Command)new GetCompletedTasksCommand(since));
    }

    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        return (List)this.executor.execute((Command)new GetCompletedTasksCommand(processId));
    }

    public Group getGroupById(String groupId) {
        return (Group)this.executor.execute((Command)new GetGroupCommand(groupId));
    }

    public List<Group> getGroups() {
        return (List)this.executor.execute((Command)new GetGroupsCommand());
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId) {
        return (List)this.executor.execute((Command)new GetSubTasksCommand(parentId, userId));
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return (List)this.executor.execute((Command)new GetSubTasksCommand(parentId));
    }

    public int getPendingSubTasksByParent(long parentId) {
        return (Integer)this.executor.execute((Command)new GetPendingSubTasksCommand(parentId));
    }

    public TaskDef getTaskDefById(String id) {
        return (TaskDef)this.executor.execute((Command)new GetTaskDefinitionCommand(id));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDate(String userId, List<Status> statuses, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksOwned(userId, statuses, new QueryFilter("t.taskData.expirationTime = :expirationDate", params, "t.id", false));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> statuses, Date expirationDate) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("expirationDate", expirationDate);
        return this.getTasksOwned(userId, statuses, new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "t.id", false));
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsExcludedOwnerCommand(userId));
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsRecipientCommand(userId));
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsInitiatorCommand(userId));
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId) {
        return (List)this.executor.execute((Command)new GetTaskAssignedAsStakeholderCommand(userId));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateBeforeSpecifiedDate(String userId, List<Status> status, Date date) {
        return (List)this.executor.execute((Command)new GetTaskOwnedByExpDateBeforeDateCommand(userId, status, date));
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceIdByTaskName(long processInstanceId, List<Status> status, String taskName) {
        return (List)this.executor.execute((Command)new GetTasksByStatusByProcessInstanceIdCommand(processInstanceId, status, taskName));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByProcessId(String userId, String processId) {
        return ((TaskSummaryQueryBuilder)((TaskSummaryQueryBuilder)this.taskSummaryQuery(userId).intersect()).potentialOwner(new String[]{userId}).processId(new String[]{processId})).build().getResultList();
    }

    public Map<Long, List<OrganizationalEntity>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        return (Map)this.executor.execute((Command)new GetPotentialOwnersForTaskCommand(taskIds));
    }

    public User getUserById(String userId) {
        return (User)this.executor.execute((Command)new GetUserCommand(userId));
    }

    public List<User> getUsers() {
        return (List)this.executor.execute((Command)new GetUsersCommand());
    }

    public long addTask(Task task, ContentData data) {
        return (Long)this.executor.execute((Command)new AddTaskCommand(task, data));
    }

    public void remove(long taskId, String userId) {
        this.executor.execute((Command)new RemoveTaskCommand(taskId, userId));
    }

    public void removeGroup(String groupId) {
        this.executor.execute((Command)new RemoveGroupCommand(groupId));
    }

    public int removeTasks(List<TaskSummary> tasks) {
        return (Integer)this.executor.execute((Command)new RemoveTasksCommand(tasks));
    }

    public void removeUser(String userId) {
        this.executor.execute((Command)new RemoveUserCommand(userId));
    }

    public void setFault(long taskId, String userId, FaultData fault) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, userId, 1, fault));
    }

    public void setOutput(long taskId, String userId, Object outputContentData) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, userId, 2, outputContentData));
    }

    public void setPriority(long taskId, int priority) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, null, 3, priority));
    }

    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, null, 4, taskNames));
    }

    public void undeployTaskDef(String id) {
        this.executor.execute((Command)new UndeployTaskDefCommand(id));
    }

    public UserInfo getUserInfo() {
        return (UserInfo)this.executor.execute((Command)new GetUserInfoCommand());
    }

    public void setUserInfo(UserInfo userInfo) {
        throw new UnsupportedOperationException("Set UserInfo object on TaskService creation");
    }

    public void addUsersAndGroups(Map<String, User> users, Map<String, Group> groups) {
        this.executor.execute((Command)new AddUsersGroupsCommand(users, groups));
    }

    public int removeAllTasks() {
        return (Integer)this.executor.execute((Command)new RemoveAllTasksCommand());
    }

    public long addContent(long taskId, Content content) {
        return (Long)this.executor.execute((Command)new AddContentCommand((Long)taskId, content));
    }

    public long addContent(long taskId, Map<String, Object> params) {
        return (Long)this.executor.execute((Command)new AddContentCommand((Long)taskId, params));
    }

    public long setDocumentContentFromUser(long taskId, String userId, byte[] content) {
        AddContentFromUserCommand cmd = new AddContentFromUserCommand(taskId, userId);
        cmd.setDocumentContentBytes(content);
        return (Long)this.executor.execute((Command)cmd);
    }

    public long addOutputContentFromUser(long taskId, String userId, Map<String, Object> params) {
        AddContentFromUserCommand cmd = new AddContentFromUserCommand(taskId, userId);
        cmd.setOutputContentMap(params);
        return (Long)this.executor.execute((Command)cmd);
    }

    public void deleteContent(long taskId, long contentId) {
        this.executor.execute((Command)new DeleteContentCommand(taskId, contentId));
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        return (List)this.executor.execute((Command)new GetAllContentCommand(taskId));
    }

    public Content getContentByIdForUser(long contentId, String userId) {
        GetContentByIdForUserCommand cmd = new GetContentByIdForUserCommand(contentId);
        cmd.setContentId(contentId);
        cmd.setUserId(userId);
        return (Content)this.executor.execute((Command)cmd);
    }

    public Map<String, Object> getOutputContentMapForUser(long taskId, String userId) {
        return (Map)this.executor.execute((Command)new GetContentMapForUserCommand(taskId, userId));
    }

    public long addAttachment(long taskId, Attachment attachment, Content content) {
        return (Long)this.executor.execute((Command)new AddAttachmentCommand((Long)taskId, attachment, content));
    }

    public void deleteAttachment(long taskId, long attachmentId) {
        this.executor.execute((Command)new DeleteAttachmentCommand(taskId, attachmentId));
    }

    public List<Attachment> getAllAttachmentsByTaskId(long taskId) {
        return (List)this.executor.execute((Command)new GetAllAttachmentsCommand(taskId));
    }

    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return (OrganizationalEntity)this.executor.execute((Command)new GetOrgEntityCommand(entityId));
    }

    public void setExpirationDate(long taskId, Date date) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, null, 5, date));
    }

    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, null, 6, descriptions));
    }

    public void setSkipable(long taskId, boolean skipable) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, null, 7, skipable));
    }

    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        this.executor.execute((Command)new SetTaskPropertyCommand(taskId, null, 8, strategy));
    }

    public int getPriority(long taskId) {
        return (Integer)this.executor.execute((Command)new GetTaskPropertyCommand(taskId, null, 3));
    }

    public Date getExpirationDate(long taskId) {
        return (Date)this.executor.execute((Command)new GetTaskPropertyCommand(taskId, null, 5));
    }

    public List<I18NText> getDescriptions(long taskId) {
        return (List)this.executor.execute((Command)new GetTaskPropertyCommand(taskId, null, 6));
    }

    public boolean isSkipable(long taskId) {
        return (Boolean)this.executor.execute((Command)new GetTaskPropertyCommand(taskId, null, 7));
    }

    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        return (SubTasksStrategy)this.executor.execute((Command)new GetTaskPropertyCommand(taskId, null, 8));
    }

    public Task getTaskInstanceById(long taskId) {
        return (Task)this.executor.execute((Command)new GetTaskCommand(taskId));
    }

    public int getCompletedTaskByUserId(String userId) {
        return (Integer)this.executor.execute((Command)new GetCompletedTasksByUserCommand(userId));
    }

    public int getPendingTaskByUserId(String userId) {
        return (Integer)this.executor.execute((Command)new GetPendingTasksByUserCommand(userId));
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId) {
        return (List)this.executor.execute((Command)new GetTaskAssignedByGroupsCommand(Collections.singletonList(groupId)));
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds) {
        return (List)this.executor.execute((Command)new GetTaskAssignedByGroupsCommand(groupIds));
    }

    public Long addComment(long taskId, Comment comment) {
        return (Long)this.executor.execute((Command)new AddCommentCommand(taskId, comment));
    }

    public Long addComment(long taskId, String addedByUserId, String commentText) {
        return (Long)this.executor.execute((Command)new AddCommentCommand(taskId, addedByUserId, commentText));
    }

    public void deleteComment(long taskId, long commentId) {
        this.executor.execute((Command)new DeleteCommentCommand(taskId, commentId));
    }

    public List<Comment> getAllCommentsByTaskId(long taskId) {
        return (List)this.executor.execute((Command)new GetAllCommentsCommand(taskId));
    }

    public Comment getCommentById(long commentId) {
        return (Comment)this.executor.execute((Command)new GetCommentCommand(commentId));
    }

    public Map<String, Object> getTaskContent(long taskId) {
        return (Map)this.executor.execute((Command)new GetTaskContentCommand(taskId));
    }

    public void addMarshallerContext(String ownerId, ContentMarshallerContext context) {
        TaskContentRegistry.get().addMarshallerContext(ownerId, context);
    }

    public void removeMarshallerContext(String ownerId) {
        TaskContentRegistry.get().removeMarshallerContext(ownerId);
    }

    public ContentMarshallerContext getMarshallerContext(Task task) {
        return TaskContentRegistry.get().getMarshallerContext(task);
    }

    public void removeTaskEventsById(long taskId) {
        throw new UnsupportedOperationException(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported on the " + this.getClass().getSimpleName());
    }

    public List<TaskEvent> getTaskEventsById(long taskId) {
        throw new UnsupportedOperationException(Thread.currentThread().getStackTrace()[1].getMethodName() + " is not supported on the " + this.getClass().getSimpleName());
    }

    public void registerTaskEventListener(TaskLifeCycleEventListener listener) {
        this.taskEventSupport.addEventListener((EventListener)listener);
    }

    public List<TaskLifeCycleEventListener> getTaskEventListeners() {
        return this.taskEventSupport.getEventListeners();
    }

    public void clearTaskEventListeners() {
        this.taskEventSupport.clear();
    }

    public void removeTaskEventListener(TaskLifeCycleEventListener listener) {
        this.taskEventSupport.removeEventListener((EventListener)listener);
    }

    public void executeReminderForTask(long taskId, String fromUser) {
        this.executor.execute((Command)new ExecuteReminderCommand(taskId, fromUser));
    }
}

