/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.date.Quarter;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.dataset.sort.SortedList;

public class IntervalBuilderDynamicDate
implements IntervalBuilder {
    private static SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");

    public IntervalList build(DataSetHandler handler, ColumnGroup columnGroup) {
        int i;
        IntervalDateRangeList results = new IntervalDateRangeList(columnGroup);
        DataSet dataSet = handler.getDataSet();
        List values = dataSet.getColumnById(columnGroup.getSourceId()).getValues();
        if (values.isEmpty()) {
            return results;
        }
        DataSetSort sortOp = new DataSetSort();
        sortOp.addSortColumn(new ColumnSort[]{new ColumnSort(columnGroup.getSourceId(), SortOrder.ASCENDING)});
        DataSetHandler sortResults = handler.sort(sortOp);
        List sortedRows = sortResults.getRows();
        if (sortedRows == null || sortedRows.isEmpty()) {
            return results;
        }
        SortedList sortedValues = new SortedList(values, sortedRows);
        Date minDate = null;
        Date maxDate = null;
        for (i = 0; minDate == null && i < sortedValues.size(); ++i) {
            minDate = (Date)sortedValues.get(i);
        }
        for (i = sortedValues.size() - 1; maxDate == null && i >= 0; --i) {
            maxDate = (Date)sortedValues.get(i);
        }
        DateIntervalType intervalType = this.calculateIntervalSize(minDate, maxDate, columnGroup);
        if (minDate == null || minDate.compareTo(maxDate) == 0) {
            IntervalDateRange interval = new IntervalDateRange(0, intervalType, minDate, maxDate);
            for (int row = 0; row < sortedValues.size(); ++row) {
                interval.getRows().add(row);
            }
            results.add((Object)interval);
            results.setIntervalType(columnGroup.getIntervalSize());
            results.setMinValue(minDate);
            results.setMaxValue(maxDate);
            return results;
        }
        Calendar c = this.firstIntervalDate(intervalType, minDate, columnGroup);
        int index = 0;
        int counter = 0;
        while (c.getTime().compareTo(maxDate) <= 0) {
            Date intervalMinDate = c.getTime();
            this.nextIntervalDate(c, intervalType, 1);
            Date intervalMaxDate = c.getTime();
            IntervalDateRange interval = new IntervalDateRange(counter++, intervalType, intervalMinDate, intervalMaxDate);
            results.add((Object)interval);
            boolean stop = false;
            while (!stop) {
                if (index >= sortedValues.size()) {
                    stop = true;
                    continue;
                }
                Date dateValue = (Date)sortedValues.get(index);
                Integer row = (Integer)sortedRows.get(index);
                if (dateValue == null) {
                    ++index;
                    continue;
                }
                if (dateValue.before(intervalMaxDate)) {
                    interval.getRows().add(row);
                    ++index;
                    continue;
                }
                stop = true;
            }
        }
        boolean asc = columnGroup.isAscendingOrder();
        if (!asc) {
            Collections.reverse(results);
        }
        results.setIntervalType(intervalType.toString());
        results.setMinValue(minDate);
        results.setMaxValue(maxDate);
        return results;
    }

    public IntervalList build(DataColumn dataColumn) {
        ColumnGroup columnGroup = dataColumn.getColumnGroup();
        Date minDate = (Date)dataColumn.getMinValue();
        Date maxDate = (Date)dataColumn.getMaxValue();
        IntervalDateRangeList results = new IntervalDateRangeList(columnGroup);
        if (minDate == null || maxDate == null) {
            return results;
        }
        DateIntervalType intervalType = DateIntervalType.getByName((String)dataColumn.getIntervalType());
        if (intervalType == null) {
            intervalType = DateIntervalType.YEAR;
        }
        Calendar c = this.firstIntervalDate(intervalType, minDate, columnGroup);
        int counter = 0;
        while (c.getTime().compareTo(maxDate) <= 0) {
            Date intervalMinDate = c.getTime();
            this.nextIntervalDate(c, intervalType, 1);
            Date intervalMaxDate = c.getTime();
            IntervalDateRange interval = new IntervalDateRange(counter++, intervalType, intervalMinDate, intervalMaxDate);
            results.add((Object)interval);
        }
        boolean asc = columnGroup.isAscendingOrder();
        if (!asc) {
            Collections.reverse(results);
        }
        results.setIntervalType(intervalType.toString());
        results.setMinValue(minDate);
        results.setMaxValue(maxDate);
        return results;
    }

    public DateIntervalType calculateIntervalSize(Date minDate, Date maxDate, ColumnGroup columnGroup) {
        DateIntervalType intervalType = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        if (intervalType == null) {
            intervalType = DateIntervalType.YEAR;
        }
        if (minDate == null || maxDate == null) {
            return intervalType;
        }
        long millis = maxDate.getTime() - minDate.getTime();
        if (millis <= 0L) {
            return intervalType;
        }
        int maxIntervals = columnGroup.getMaxIntervals();
        if (maxIntervals < 1) {
            maxIntervals = 15;
        }
        for (DateIntervalType type : DateIntervalType.values()) {
            long nintervals = millis / DateIntervalType.getDurationInMillis((DateIntervalType)type);
            if (nintervals >= (long)maxIntervals) continue;
            intervalType = type;
            break;
        }
        DateIntervalType intervalSize = null;
        if (!StringUtils.isBlank((CharSequence)columnGroup.getIntervalSize())) {
            intervalSize = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        }
        if (intervalSize != null && DateIntervalType.compare((DateIntervalType)intervalType, (DateIntervalType)intervalSize) == -1) {
            intervalType = intervalSize;
        }
        return intervalType;
    }

    protected Calendar firstIntervalDate(DateIntervalType intervalType, Date minDate, ColumnGroup columnGroup) {
        Calendar c = GregorianCalendar.getInstance();
        c.setLenient(false);
        c.setTime(minDate);
        if (DateIntervalType.YEAR.equals((Object)intervalType)) {
            c.set(2, 0);
            c.set(5, 1);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
            int currentMonth = c.get(2);
            int firstMonthYear = columnGroup.getFirstMonthOfYear().getIndex();
            int rest = Quarter.getPositionInQuarter((int)firstMonthYear, (int)(currentMonth + 1));
            c.add(2, rest * -1);
            c.set(5, 1);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        if (DateIntervalType.MONTH.equals((Object)intervalType)) {
            c.set(5, 1);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType) || DateIntervalType.WEEK.equals((Object)intervalType)) {
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            c.set(13, 0);
            c.set(14, 0);
        }
        if (DateIntervalType.SECOND.equals((Object)intervalType)) {
            c.set(14, 0);
        }
        return c;
    }

    protected void nextIntervalDate(Calendar c, DateIntervalType intervalType, int intervals) {
        if (DateIntervalType.MILLENIUM.equals((Object)intervalType)) {
            c.add(1, 1000 * intervals);
        } else if (DateIntervalType.CENTURY.equals((Object)intervalType)) {
            c.add(1, 100 * intervals);
        } else if (DateIntervalType.DECADE.equals((Object)intervalType)) {
            c.add(1, 10 * intervals);
        } else if (DateIntervalType.YEAR.equals((Object)intervalType)) {
            c.add(1, intervals);
        } else if (DateIntervalType.QUARTER.equals((Object)intervalType)) {
            c.add(2, 3 * intervals);
        } else if (DateIntervalType.MONTH.equals((Object)intervalType)) {
            c.add(2, intervals);
        } else if (DateIntervalType.WEEK.equals((Object)intervalType)) {
            c.add(5, 7 * intervals);
        } else if (DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
            c.add(5, intervals);
        } else if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            c.add(11, intervals);
        } else if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            c.add(12, intervals);
        } else if (DateIntervalType.SECOND.equals((Object)intervalType)) {
            c.add(13, intervals);
        } else {
            c.add(1, intervals);
        }
    }

    public Interval locate(DataColumn column, Integer intervalIndex) {
        ColumnGroup columnGroup = column.getColumnGroup();
        Date columnMinDate = (Date)column.getMinValue();
        String type = column.getIntervalType();
        if (columnGroup == null) {
            return null;
        }
        if (columnMinDate == null) {
            return null;
        }
        if (type == null) {
            return null;
        }
        DateIntervalType intervalType = DateIntervalType.getByName((String)type);
        Calendar c = this.firstIntervalDate(intervalType, columnMinDate, columnGroup);
        this.nextIntervalDate(c, intervalType, intervalIndex);
        Date intervalMinDate = c.getTime();
        this.nextIntervalDate(c, intervalType, 1);
        Date intervalMaxDate = c.getTime();
        return new IntervalDateRange(intervalIndex, intervalType, intervalMinDate, intervalMaxDate);
    }

    public static String calculateName(DateIntervalType intervalType, Date d) {
        if (d == null) {
            return null;
        }
        Locale l = Locale.getDefault();
        if (DateIntervalType.MILLENIUM.equals((Object)intervalType) || DateIntervalType.CENTURY.equals((Object)intervalType) || DateIntervalType.DECADE.equals((Object)intervalType) || DateIntervalType.YEAR.equals((Object)intervalType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy", l);
            return format.format(d);
        }
        if (DateIntervalType.QUARTER.equals((Object)intervalType) || DateIntervalType.MONTH.equals((Object)intervalType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM", l);
            return format.format(d);
        }
        if (DateIntervalType.WEEK.equals((Object)intervalType) || DateIntervalType.DAY.equals((Object)intervalType) || DateIntervalType.DAY_OF_WEEK.equals((Object)intervalType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return format.format(d);
        }
        if (DateIntervalType.HOUR.equals((Object)intervalType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH");
            return format.format(d);
        }
        if (DateIntervalType.MINUTE.equals((Object)intervalType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            return format.format(d);
        }
        if (DateIntervalType.SECOND.equals((Object)intervalType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.format(d);
        }
        return format.format(d);
    }

    public class IntervalDateRange
    extends Interval {
        public IntervalDateRange(int index, DateIntervalType intervalType, Date minDate, Date maxDate) {
            super(IntervalBuilderDynamicDate.calculateName(intervalType, minDate));
            super.setMinValue((Object)minDate);
            super.setMaxValue((Object)maxDate);
            super.setIndex(index);
            super.setType(intervalType != null ? intervalType.toString() : null);
        }

        public Date getMinDate() {
            return (Date)this.minValue;
        }

        public Date getMaxDate() {
            return (Date)this.maxValue;
        }
    }

    public class IntervalDateRangeList
    extends IntervalList {
        public IntervalDateRangeList(ColumnGroup columnGroup) {
            super(columnGroup);
        }

        public Interval locateInterval(Object value) {
            Date d = (Date)value;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Interval interval = (Interval)iterator.next();
                IntervalDateRange dateRange = (IntervalDateRange)interval;
                if (!d.equals(dateRange.getMinDate()) && (!d.after(dateRange.getMinDate()) || !d.before(dateRange.getMaxDate()))) continue;
                return interval;
            }
            return null;
        }
    }
}

