/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.internal;

import java.io.File;
import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineBuilder;
import org.kie.remote.client.api.exception.InsufficientInfoToBuildException;
import org.kie.remote.client.internal.AbstractRemoteRuntimeEngineBuilderImpl;
import org.kie.remote.client.internal.RemoteRuntimeEngineFactory;
import org.kie.remote.client.internal.command.RemoteConfiguration;
import org.kie.remote.client.internal.command.RemoteRuntimeEngine;

class RemoteJmsRuntimeEngineBuilderImpl
extends AbstractRemoteRuntimeEngineBuilderImpl<RemoteJmsRuntimeEngineBuilder>
implements RemoteJmsRuntimeEngineBuilder {
    InitialContext remoteInitialContext = null;
    String jbossServerHostName = null;
    boolean createOwnFactory = false;
    String hostName = null;
    Integer jmsConnectorPort = null;
    String keystorePassword;
    String keystoreLocation;
    String truststorePassword;
    String truststoreLocation;
    boolean useKeystoreAsTruststore = false;

    RemoteJmsRuntimeEngineBuilderImpl() {
        this.config = new RemoteConfiguration(RemoteConfiguration.Type.JMS);
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addRemoteInitialContext(InitialContext remoteInitialContext) {
        this.remoteInitialContext = remoteInitialContext;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addJbossServerHostName(String hostname) {
        this.jbossServerHostName = hostname;
        this.addHostName(hostname);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addKieSessionQueue(Queue ksessionQueue) {
        this.config.setKsessionQueue(ksessionQueue);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addTaskServiceQueue(Queue taskServiceQueue) {
        this.config.setTaskQueue(taskServiceQueue);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addResponseQueue(Queue responseQueue) {
        this.config.setResponseQueue(responseQueue);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addConnectionFactory(ConnectionFactory connectionFactory) {
        this.config.setConnectionFactory(connectionFactory);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addHostName(String hostNameOrIp) {
        this.createOwnFactory = true;
        this.hostName = hostNameOrIp;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addJmsConnectorPort(int port) {
        this.createOwnFactory = true;
        this.jmsConnectorPort = port;
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl useSsl(boolean useSsl) {
        this.createOwnFactory = useSsl;
        this.config.setUseSsl(useSsl);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addKeystoreLocation(String keystoreLocation) {
        this.keystoreLocation = keystoreLocation;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl addTruststoreLocation(String truststoreLocation) {
        this.truststoreLocation = truststoreLocation;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl useKeystoreAsTruststore() {
        this.useKeystoreAsTruststore = true;
        this.useSsl(true);
        return this;
    }

    @Override
    public RemoteJmsRuntimeEngineBuilderImpl disableTaskSecurity() {
        this.config.setDisableTaskSecurity(true);
        return this;
    }

    private void checkAndFinalizeConfig() {
        RemoteRuntimeEngineFactory.checkAndFinalizeConfig(this.config, this);
    }

    @Override
    public RemoteRuntimeEngine build() {
        this.checkAndFinalizeConfig();
        return new RemoteRuntimeEngine(this.config.clone());
    }

    void checkKeyAndTruststoreInfo() {
        String[][] pathInfos;
        if (this.useKeystoreAsTruststore) {
            this.truststoreLocation = this.keystoreLocation;
            this.truststorePassword = this.keystorePassword;
        }
        if (this.keystorePassword == null) {
            throw new InsufficientInfoToBuildException("A keystore password is required to build the SSL JMS connection factory.");
        }
        if (this.truststorePassword == null) {
            throw new InsufficientInfoToBuildException("A truststore password is required to build the SSL JMS connection factory.");
        }
        for (String[] pathInfo : pathInfos = new String[][]{{this.keystoreLocation, "keystore"}, {this.truststoreLocation, "truststore"}}) {
            Serializable storeFile;
            String path = pathInfo[0];
            String name = pathInfo[1];
            if (path == null) {
                throw new InsufficientInfoToBuildException("A " + name + " location is required to build the SSL JMS connection factory.");
            }
            if (path.startsWith("/")) {
                storeFile = new File(path);
                if (storeFile.exists()) continue;
                throw new InsufficientInfoToBuildException("No " + name + " file could be found at '" + path + "'");
            }
            storeFile = this.getClass().getResource("/" + path);
            if (storeFile != null) continue;
            throw new InsufficientInfoToBuildException("No " + name + " file could be found on the classpath at '" + path + "'");
        }
    }

    public static RemoteJmsRuntimeEngineBuilderImpl newBuilder() {
        return new RemoteJmsRuntimeEngineBuilderImpl();
    }
}

