/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.internal;

import java.net.URL;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.internal.AbstractRemoteRuntimeEngineBuilderImpl;
import org.kie.remote.client.internal.RemoteRuntimeEngineFactory;
import org.kie.remote.client.internal.command.RemoteConfiguration;
import org.kie.remote.client.internal.command.RemoteRuntimeEngine;

class RemoteRestRuntimeEngineBuilderImpl
extends AbstractRemoteRuntimeEngineBuilderImpl<RemoteRestRuntimeEngineBuilder>
implements RemoteRestRuntimeEngineBuilder {
    URL url;

    RemoteRestRuntimeEngineBuilderImpl() {
        this.config = new RemoteConfiguration(RemoteConfiguration.Type.REST);
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addUrl(URL url) {
        this.config.setServerBaseRestUrl(url);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl disableTaskSecurity() {
        this.config.setDisableTaskSecurity(true);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilder addHeader(String headerFieldName, String headerFieldValue) {
        this.config.addHeader(headerFieldName, headerFieldValue);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilder clearHeaderFields() {
        this.config.clearHeaders();
        return this;
    }

    private void checkAndFinalizeConfig() {
        RemoteRuntimeEngineFactory.checkAndFinalizeConfig(this.config, this);
    }

    @Override
    public RemoteRuntimeEngine build() {
        this.checkAndFinalizeConfig();
        return new RemoteRuntimeEngine(this.config.clone());
    }

    public static RemoteRestRuntimeEngineBuilderImpl newBuilder() {
        return new RemoteRestRuntimeEngineBuilderImpl();
    }
}

