/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.jaxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kie.internal.jaxb.StringKeyObjectValueEntry;
import org.kie.internal.jaxb.StringKeyObjectValueMap;
import org.kie.remote.jaxb.gen.JaxbStringObjectPairArray;
import org.kie.remote.jaxb.gen.OrganizationalEntity;
import org.kie.remote.jaxb.gen.Type;
import org.kie.remote.jaxb.gen.util.JaxbStringObjectPair;
import org.kie.remote.jaxb.gen.util.JaxbUnknownAdapter;

public class ConversionUtil {
    private static final JaxbUnknownAdapter unknownAdapter = new JaxbUnknownAdapter();
    private static DatatypeFactory datatypeFactory;

    public static Date convertXmlGregCalToDate(XMLGregorianCalendar xmlCal) {
        if (xmlCal == null) {
            return null;
        }
        return xmlCal.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar convertDateToXmlGregorianCalendar(Date date) {
        if (date != null) {
            GregorianCalendar gregorianCal = new GregorianCalendar();
            gregorianCal.setTime(date);
            return datatypeFactory.newXMLGregorianCalendar(gregorianCal);
        }
        return null;
    }

    public static JaxbStringObjectPairArray convertMapToJaxbStringObjectPairArray(Map<String, Object> map) {
        JaxbStringObjectPairArray arrayMap = new JaxbStringObjectPairArray();
        if (map == null || map.isEmpty()) {
            return arrayMap;
        }
        List<JaxbStringObjectPair> items = arrayMap.getItems();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            JaxbStringObjectPair pair = new JaxbStringObjectPair();
            pair.setKey(entry.getKey());
            try {
                pair.setValue(unknownAdapter.marshal(entry.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to serialize map in command: " + e.getMessage(), e);
            }
            items.add(pair);
        }
        return arrayMap;
    }

    public static StringKeyObjectValueMap convertMapToStringKeyObjectValueMap(Map<String, Object> map) {
        StringKeyObjectValueMap jaxbMap = new StringKeyObjectValueMap();
        if (map == null || map.isEmpty()) {
            return jaxbMap;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jaxbMap.addEntry(new StringKeyObjectValueEntry(entry));
        }
        return jaxbMap;
    }

    public static List<OrganizationalEntity> convertStringListToGenOrgEntList(List<String> orgEntIdList) {
        if (orgEntIdList == null) {
            return new ArrayList<OrganizationalEntity>(0);
        }
        ArrayList<OrganizationalEntity> genOrgEntList = new ArrayList<OrganizationalEntity>(orgEntIdList.size());
        for (String orgEntId : orgEntIdList) {
            OrganizationalEntity orgEnt = new OrganizationalEntity();
            orgEnt.setId(orgEntId);
            orgEnt.setType(Type.USER);
        }
        return genOrgEntList;
    }

    public static byte[] convertSerializableToByteArray(Serializable input) {
        byte[] result = null;
        return result;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Unable to instantiate " + DatatypeFactory.class.getName() + ": " + e.getMessage(), e);
        }
    }
}

