/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.runtime.manager.impl.RuntimeEngineInitlializer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.DisposeListener;
import org.kie.internal.runtime.manager.InternalRuntimeManager;

public class RuntimeEngineImpl
implements RuntimeEngine,
Disposable {
    private RuntimeEngineInitlializer initializer;
    private Context<?> context;
    private KieSession ksession;
    private TaskService taskService;
    private AuditService auditService;
    private RuntimeManager manager;
    private boolean disposed = false;
    private boolean afterCompletion = false;
    private List<DisposeListener> listeners = new CopyOnWriteArrayList<DisposeListener>();

    public RuntimeEngineImpl(KieSession ksession, TaskService taskService) {
        this.ksession = ksession;
        this.taskService = taskService;
    }

    public RuntimeEngineImpl(Context<?> context, RuntimeEngineInitlializer initializer) {
        this.context = context;
        this.initializer = initializer;
    }

    public KieSession getKieSession() {
        if (this.disposed) {
            throw new IllegalStateException("This runtime is already diposed");
        }
        if (this.ksession == null && this.initializer != null) {
            this.ksession = this.initializer.initKieSession(this.context, (InternalRuntimeManager)this.manager, this);
        }
        return this.ksession;
    }

    public TaskService getTaskService() {
        if (this.disposed) {
            throw new IllegalStateException("This runtime is already diposed");
        }
        if (this.taskService == null) {
            if (this.initializer != null) {
                this.taskService = this.initializer.initTaskService(this.context, (InternalRuntimeManager)this.manager, this);
            }
            if (this.taskService == null) {
                throw new UnsupportedOperationException("TaskService was not configured");
            }
        }
        return this.taskService;
    }

    public void dispose() {
        if (!this.disposed) {
            for (DisposeListener listener : this.listeners) {
                listener.onDispose((RuntimeEngine)this);
            }
            if (this.ksession != null) {
                try {
                    this.ksession.dispose();
                }
                catch (IllegalStateException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.auditService != null) {
                this.auditService.dispose();
            }
            this.disposed = true;
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.disposed) {
            throw new IllegalStateException("This runtime is already diposed");
        }
        this.listeners.add(listener);
    }

    public RuntimeManager getManager() {
        return this.manager;
    }

    public void setManager(RuntimeManager manager) {
        this.manager = manager;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public AuditService getAuditService() {
        if (this.auditService == null) {
            boolean usePersistence = ((InternalRuntimeManager)this.manager).getEnvironment().usePersistence();
            if (usePersistence) {
                this.auditService = new JPAAuditLogService(this.getKieSession().getEnvironment());
            } else {
                throw new UnsupportedOperationException("AuditService was not configured, supported only with persistence");
            }
        }
        return this.auditService;
    }

    public KieSession internalGetKieSession() {
        return this.ksession;
    }

    public void internalSetKieSession(KieSession ksession) {
        this.ksession = ksession;
    }

    public boolean isAfterCompletion() {
        return this.afterCompletion;
    }

    public void setAfterCompletion(boolean completing) {
        this.afterCompletion = completing;
    }
}

