/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.kie.remote.client.api.RemoteWebserviceClientBuilder;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.command.RemoteConfiguration;

abstract class RemoteWebserviceClientBuilderImpl<S>
implements RemoteWebserviceClientBuilder<RemoteWebserviceClientBuilder, S> {
    protected RemoteConfiguration config = new RemoteConfiguration(RemoteConfiguration.Type.WS);

    RemoteWebserviceClientBuilderImpl() {
    }

    @Override
    public RemoteWebserviceClientBuilder addUserName(String userName) {
        this.config.setUserName(userName);
        return this;
    }

    @Override
    public RemoteWebserviceClientBuilder addPassword(String password) {
        this.config.setPassword(password);
        return this;
    }

    @Override
    public RemoteWebserviceClientBuilder addServerUrl(URL url) {
        this.config.setServerBaseWsUrl(url);
        return this;
    }

    @Override
    public RemoteWebserviceClientBuilder addServerUrl(String instanceUrlString) throws MalformedURLException {
        URL serverUrl = new URL(instanceUrlString);
        this.config.setServerBaseWsUrl(serverUrl);
        return this;
    }

    @Override
    public RemoteWebserviceClientBuilder addTimeout(int timeoutInSeconds) {
        this.config.setTimeout(timeoutInSeconds);
        return this;
    }

    @Override
    public RemoteWebserviceClientBuilder addDeploymentId(String deploymentId) {
        this.config.setDeploymentId(deploymentId);
        return this;
    }

    @Override
    public RemoteWebserviceClientBuilder addExtraJaxbClasses(Class ... classes) {
        HashSet classSet = new HashSet();
        for (Class clazz : classes) {
            classSet.add(clazz);
        }
        this.config.addJaxbClasses(classSet);
        return this;
    }

    protected void checkAndFinalizeConfig() {
        RemoteRuntimeEngineFactory.checkAndFinalizeConfig(this.config, this);
    }
}

