/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jms.Queue;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.jaxb.CorrelationKeyXmlAdapter;
import org.kie.internal.process.CorrelationKey;
import org.kie.remote.client.api.exception.MissingRequiredInfoException;
import org.kie.remote.client.api.exception.RemoteApiException;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.remote.client.api.exception.RemoteTaskException;
import org.kie.remote.client.jaxb.AcceptedClientCommands;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.remote.jaxb.gen.AddTaskCommand;
import org.kie.remote.jaxb.gen.AuditCommand;
import org.kie.remote.jaxb.gen.CompleteTaskCommand;
import org.kie.remote.jaxb.gen.CompleteWorkItemCommand;
import org.kie.remote.jaxb.gen.FailTaskCommand;
import org.kie.remote.jaxb.gen.InsertObjectCommand;
import org.kie.remote.jaxb.gen.JaxbStringObjectPairArray;
import org.kie.remote.jaxb.gen.SetGlobalCommand;
import org.kie.remote.jaxb.gen.SignalEventCommand;
import org.kie.remote.jaxb.gen.StartCorrelatedProcessCommand;
import org.kie.remote.jaxb.gen.StartProcessCommand;
import org.kie.remote.jaxb.gen.TaskCommand;
import org.kie.remote.jaxb.gen.UpdateCommand;
import org.kie.remote.jaxb.gen.util.JaxbStringObjectPair;
import org.kie.services.client.api.command.InternalJmsCommandHelper;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbRestRequestException;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteCommandObject {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRemoteCommandObject.class);
    protected final RemoteConfiguration config;
    protected boolean isTaskService = false;

    AbstractRemoteCommandObject(RemoteConfiguration config) {
        this.config = config;
        if (config.isJms() && config.getResponseQueue() == null) {
            throw new MissingRequiredInfoException("A Response queue is necessary in order to create a Remote JMS Client instance.");
        }
        this.config.initializeJaxbSerializationProvider();
    }

    protected void dispose() {
    }

    protected String convertCorrelationKeyToString(CorrelationKey correlationKey) {
        try {
            return CorrelationKeyXmlAdapter.marshalCorrelationKey((CorrelationKey)correlationKey);
        }
        catch (Exception e) {
            throw new RemoteApiException("Unable to marshal correlation key to a string value", e);
        }
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    protected <T> T executeCommand(Command cmd) {
        if (AcceptedClientCommands.isSendObjectParameterCommandClass(cmd.getClass())) {
            ArrayList<Object> extraClassInstanceList = new ArrayList<Object>();
            this.preprocessCommand(cmd, extraClassInstanceList);
            if (!extraClassInstanceList.isEmpty()) {
                HashSet extraJaxbClasses = new HashSet();
                for (Object e : extraClassInstanceList) {
                    Class<?> jaxbClass = e.getClass();
                    if (jaxbClass.isLocalClass() || jaxbClass.isAnonymousClass()) {
                        throw new SerializationException("Only proper classes are allowed as parameters for the remote API: neither local nor anonymous classes are accepted: " + jaxbClass.getName());
                    }
                    extraJaxbClasses.add(jaxbClass);
                }
                if (this.config.addJaxbClasses(extraJaxbClasses)) {
                    for (Class clazz : extraJaxbClasses) {
                        logger.debug("Adding {} to the JAXBContext instance in this client instance.", (Object)clazz.getName());
                    }
                    this.config.initializeJaxbSerializationProvider();
                }
            }
        }
        if (this.config.isRest()) {
            return this.executeRestCommand(cmd);
        }
        return this.executeJmsCommand(cmd);
    }

    void preprocessCommand(Object cmdObj, List<Object> extraClassInstanceList) {
        if (cmdObj instanceof CompleteWorkItemCommand) {
            this.addPossiblyNullObject(((CompleteWorkItemCommand)cmdObj).getResult(), extraClassInstanceList);
        } else if (cmdObj instanceof SignalEventCommand) {
            this.addPossiblyNullObject(((SignalEventCommand)cmdObj).getEvent(), extraClassInstanceList);
        } else if (cmdObj instanceof StartCorrelatedProcessCommand) {
            StartCorrelatedProcessCommand cmd = (StartCorrelatedProcessCommand)cmdObj;
            if (cmd.getData() != null) {
                this.addPossiblyNullObject(cmd.getData().getDatas(), extraClassInstanceList);
            }
            this.addPossiblyNullObject(cmd.getParameter(), extraClassInstanceList);
        } else if (cmdObj instanceof StartProcessCommand) {
            StartProcessCommand startProcCmd = (StartProcessCommand)cmdObj;
            if (startProcCmd.getData() != null) {
                this.addPossiblyNullObject(startProcCmd.getData().getDatas(), extraClassInstanceList);
            }
            this.addPossiblyNullObject(((StartProcessCommand)cmdObj).getParameter(), extraClassInstanceList);
        } else if (cmdObj instanceof SetGlobalCommand) {
            this.addPossiblyNullObject(((SetGlobalCommand)cmdObj).getObject(), extraClassInstanceList);
        } else if (cmdObj instanceof InsertObjectCommand) {
            this.addPossiblyNullObject(((InsertObjectCommand)cmdObj).getObject(), extraClassInstanceList);
        } else if (cmdObj instanceof UpdateCommand) {
            this.addPossiblyNullObject(((UpdateCommand)cmdObj).getObject(), extraClassInstanceList);
        } else if (cmdObj instanceof AddTaskCommand) {
            this.addPossiblyNullObject(((AddTaskCommand)cmdObj).getParameter(), extraClassInstanceList);
        } else if (cmdObj instanceof CompleteTaskCommand) {
            this.addPossiblyNullObject(((CompleteTaskCommand)cmdObj).getData(), extraClassInstanceList);
        } else if (cmdObj instanceof FailTaskCommand) {
            this.addPossiblyNullObject(((FailTaskCommand)cmdObj).getData(), extraClassInstanceList);
        }
    }

    void addPossiblyNullObject(Object inputObject, List<Object> objectList) {
        if (inputObject != null) {
            if (inputObject instanceof List) {
                objectList.addAll((List)inputObject);
            } else if (inputObject instanceof JaxbStringObjectPairArray) {
                for (JaxbStringObjectPair stringObjectPair : ((JaxbStringObjectPairArray)inputObject).getItems()) {
                    objectList.add(stringObjectPair.getValue());
                }
            } else {
                objectList.add(inputObject);
            }
        }
    }

    static JaxbCommandsRequest prepareCommandRequest(Command command, String userName, String deploymentId, Long processInstanceId, Collection<String> correlationKeyProps) {
        TaskCommand taskCmd;
        if (deploymentId == null && !(command instanceof TaskCommand) && !(command instanceof AuditCommand)) {
            throw new MissingRequiredInfoException("A deployment id is required when sending commands involving the KieSession.");
        }
        JaxbCommandsRequest req = command instanceof AuditCommand ? new JaxbCommandsRequest(command) : new JaxbCommandsRequest(deploymentId, command);
        if (command instanceof TaskCommand && (taskCmd = (TaskCommand)command).getUserId() == null) {
            taskCmd.setUserId(userName);
        }
        if (processInstanceId == null && command instanceof ProcessInstanceIdCommand) {
            processInstanceId = ((ProcessInstanceIdCommand)command).getProcessInstanceId();
        }
        if (correlationKeyProps != null && !correlationKeyProps.isEmpty()) {
            StringBuffer correlationKeyString = new StringBuffer();
            Iterator<String> iter = correlationKeyProps.iterator();
            correlationKeyString.append(iter.next());
            while (iter.hasNext()) {
                correlationKeyString.append(":").append(iter.next());
            }
            req.setCorrelationKeyString(correlationKeyString.toString());
        }
        req.setProcessInstanceId(processInstanceId);
        req.setUser(userName);
        req.setVersion("6.2.1.1");
        return req;
    }

    private <T> T executeJmsCommand(Command command) {
        Queue sendQueue;
        boolean isTaskCommand = command instanceof TaskCommand;
        if (isTaskCommand) {
            sendQueue = this.config.getTaskQueue();
            if (!this.config.getUseUssl() && !this.config.getDisableTaskSecurity()) {
                throw new RemoteCommunicationException("Task operation requests can only be sent via JMS if SSL is used.");
            }
        } else {
            sendQueue = this.config.getKsessionQueue();
        }
        return InternalJmsCommandHelper.internalExecuteJmsCommand(command, this.config.getConnectionUserName(), this.config.getConnectionPassword(), this.config.getUserName(), this.config.getPassword(), this.config.getDeploymentId(), this.config.getProcessInstanceId(), this.config.getCorrelationProperties(), this.config.getConnectionFactory(), sendQueue, this.config.getResponseQueue(), (SerializationProvider)this.config.getJaxbSerializationProvider(), this.config.getExtraJaxbClasses(), this.config.getSerializationType(), this.config.getTimeout());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T executeRestCommand(Command command) {
        String cmdName = command.getClass().getSimpleName();
        JaxbCommandsRequest jaxbRequest = AbstractRemoteCommandObject.prepareCommandRequest(command, this.config.getUserName(), this.config.getDeploymentId(), this.config.getProcessInstanceId(), this.config.getCorrelationProperties());
        KieRemoteHttpRequest httpRequest = this.config.createHttpRequest().relativeRequest("/execute");
        String deploymentId = this.config.getDeploymentId();
        if (!AbstractRemoteCommandObject.emptyDeploymentId(deploymentId)) {
            httpRequest.header("Kie-Deployment-Id", (Object)deploymentId);
        }
        String jaxbRequestString = this.config.getJaxbSerializationProvider().serialize((Object)jaxbRequest);
        if (logger.isTraceEnabled()) {
            try {
                logger.trace("Sending {} via POST to {}", (Object)command.getClass().getSimpleName(), (Object)httpRequest.getUri());
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.trace("Serialized JaxbCommandsRequest:\n {}", (Object)jaxbRequestString);
        }
        KieRemoteHttpResponse httpResponse = null;
        try {
            logger.debug("Sending POST request with " + command.getClass().getSimpleName() + " to " + httpRequest.getUri());
            httpRequest.contentType("application/xml");
            httpRequest.accept("application/xml");
            httpRequest.body((CharSequence)jaxbRequestString);
            httpRequest.post();
            httpResponse = httpRequest.response();
        }
        catch (Exception e) {
            httpRequest.disconnect();
            throw new RemoteCommunicationException("Unable to send HTTP POST request", e);
        }
        boolean htmlException = false;
        JaxbExceptionResponse exceptionResponse = null;
        JaxbCommandsResponse commandResponse = null;
        int responseStatus = httpResponse.code();
        try {
            String content = httpResponse.body();
            if (responseStatus < 300) {
                commandResponse = this.deserializeResponseContent(content, JaxbCommandsResponse.class);
            } else {
                String contentType = httpResponse.contentType();
                if (contentType.equals("application/xml")) {
                    JaxbExceptionResponse response = this.deserializeResponseContent(content, JaxbExceptionResponse.class);
                    if (response instanceof JaxbRestRequestException) {
                        JaxbRestRequestException exception = (JaxbRestRequestException)response;
                        exceptionResponse = new JaxbExceptionResponse(exception.getUrl(), exception.getCause(), exception.getStatus());
                        exceptionResponse.setCommandName(cmdName);
                        exceptionResponse.setIndex(Integer.valueOf(0));
                        exceptionResponse.setMessage(exception.getMessage());
                    } else if (response instanceof JaxbExceptionResponse) {
                        exceptionResponse = response;
                    }
                } else {
                    if (!contentType.startsWith("text/html")) throw new RemoteCommunicationException("Unable to deserialize response with content type '" + contentType + "'");
                    htmlException = true;
                    exceptionResponse = new JaxbExceptionResponse();
                    Document doc = Jsoup.parse((String)content);
                    String body = doc.body().text();
                    exceptionResponse.setMessage(body);
                    exceptionResponse.setUrl(httpRequest.getUri().toString());
                    exceptionResponse.setStackTrace("");
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve response content from request with status {}: {}", (Object)e.getMessage(), (Object)e);
            throw new RemoteCommunicationException("Unable to retrieve content from response!", e);
        }
        finally {
            httpRequest.disconnect();
        }
        if (commandResponse != null) {
            List<JaxbCommandResponse<?>> responses = commandResponse.getResponses();
            if (responses.size() == 0) {
                return null;
            }
            if (responses.size() != 1) throw new RemoteCommunicationException("Unexpected number of results from " + command.getClass().getSimpleName() + ":" + responses.size() + " results instead of only 1");
            JaxbCommandResponse<?> responseObject = responses.get(0);
            if (!(responseObject instanceof JaxbExceptionResponse)) return (T)responseObject.getResult();
            exceptionResponse = (JaxbExceptionResponse)responseObject;
        }
        logger.error("Response with status {} returned.", (Object)responseStatus);
        switch (responseStatus) {
            case 409: {
                throw new RemoteTaskException(exceptionResponse.getMessage() + ":\n" + exceptionResponse.getStackTrace());
            }
        }
        if (exceptionResponse == null) throw new RemoteCommunicationException("Unable to communicate with remote API via URL '" + httpRequest.getUri().toString() + "'");
        if (htmlException) throw new RemoteCommunicationException(exceptionResponse.getMessage() + ":\n" + exceptionResponse.getStackTrace());
        throw new RemoteApiException(exceptionResponse.getMessage() + ":\n" + exceptionResponse.getStackTrace());
    }

    private <T> T deserializeResponseContent(String responseBody, Class<T> entityClass) {
        JaxbSerializationProvider jaxbSerializationProvider = this.config.getJaxbSerializationProvider();
        Object responseEntity = null;
        try {
            responseEntity = jaxbSerializationProvider.deserialize(responseBody);
        }
        catch (ClassCastException cce) {
            throw new RemoteApiException("Unexpected entity in response body, expected " + entityClass.getName() + " instance.", cce);
        }
        return (T)responseEntity;
    }

    protected static <T> T getField(String fieldName, Class objClass, Object obj, Class<T> fieldClass) throws Exception {
        Field field = objClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    public static <T> T unsupported(Class<?> realClass, Class<T> returnClass) {
        String methodName = new Throwable().getStackTrace()[1].getMethodName();
        throw new UnsupportedOperationException("The " + realClass.getSimpleName() + "." + methodName + "(..) method is not supported on the Remote Client instance.");
    }

    public static boolean emptyDeploymentId(String deploymentId) {
        return deploymentId == null || deploymentId.trim().isEmpty();
    }
}

