/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.timer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProtobufProcessMarshaller;
import org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessRuntimeImpl;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.runtime.KieSession;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerManager {
    private static final Logger logger = LoggerFactory.getLogger(TimerManager.class);
    private long timerId = 0L;
    private InternalKnowledgeRuntime kruntime;
    private TimerService timerService;
    private Map<Long, TimerInstance> timers = new ConcurrentHashMap<Long, TimerInstance>();
    public static final Job processJob = new ProcessJob();
    public static final Job startProcessJob = new StartProcessJob();

    public TimerManager(InternalKnowledgeRuntime kruntime, TimerService timerService) {
        this.kruntime = kruntime;
        this.timerService = timerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimer(TimerInstance timer, ProcessInstance processInstance) {
        try {
            this.kruntime.startOperation();
            this.kruntime.executeQueuedActions();
            timer.setId(++this.timerId);
            timer.setProcessInstanceId(processInstance.getId());
            timer.setSessionId(((KieSession)this.kruntime).getIdentifier());
            timer.setActivated(new Date());
            IntervalTrigger trigger = null;
            if (timer.getCronExpression() != null) {
                Date startTime = new Date(this.timerService.getCurrentTime() + 1000L);
                trigger = new CronTrigger(this.timerService.getCurrentTime(), startTime, null, -1, timer.getCronExpression(), null, null);
                timer.setPeriod(1L);
            } else {
                trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, timer.getRepeatLimit(), timer.getDelay(), timer.getPeriod(), null, null);
            }
            ProcessJobContext ctx = new ProcessJobContext(timer, (Trigger)trigger, processInstance.getId(), this.kruntime);
            JobHandle jobHandle = this.timerService.scheduleJob(processJob, (JobContext)ctx, (Trigger)trigger);
            timer.setJobHandle(jobHandle);
            this.timers.put(timer.getId(), timer);
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimer(TimerInstance timer, String processId, Map<String, Object> params) {
        try {
            this.kruntime.startOperation();
            this.kruntime.executeQueuedActions();
            timer.setId(++this.timerId);
            timer.setProcessInstanceId(-1L);
            timer.setSessionId(((StatefulKnowledgeSession)this.kruntime).getIdentifier());
            timer.setActivated(new Date());
            IntervalTrigger trigger = null;
            if (timer.getCronExpression() != null) {
                Date startTime = new Date(this.timerService.getCurrentTime() + 1000L);
                trigger = new CronTrigger(this.timerService.getCurrentTime(), startTime, null, -1, timer.getCronExpression(), null, null);
                timer.setPeriod(1L);
            } else {
                trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, timer.getRepeatLimit(), timer.getDelay(), timer.getPeriod(), null, null);
            }
            StartProcessJobContext ctx = new StartProcessJobContext(timer, (Trigger)trigger, processId, params, this.kruntime);
            JobHandle jobHandle = this.timerService.scheduleJob(startProcessJob, (JobContext)ctx, (Trigger)trigger);
            timer.setJobHandle(jobHandle);
            this.timers.put(timer.getId(), timer);
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public void internalAddTimer(TimerInstance timer) {
        long delay;
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered == null) {
            Date activated = timer.getActivated();
            Date now = new Date();
            long timespan = now.getTime() - activated.getTime();
            delay = timer.getDelay() - timespan;
            if (delay < 0L) {
                delay = 0L;
            }
        } else {
            Date now = new Date();
            long timespan = now.getTime() - lastTriggered.getTime();
            delay = timespan - timer.getPeriod();
            if (delay < 0L) {
                delay = 0L;
            }
        }
        IntervalTrigger trigger = new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, delay, timer.getPeriod(), null, null);
        ProcessJobContext ctx = new ProcessJobContext(timer, (Trigger)trigger, timer.getProcessInstanceId(), this.kruntime);
        JobHandle jobHandle = this.timerService.scheduleJob(processJob, (JobContext)ctx, (Trigger)trigger);
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(long timerId) {
        try {
            this.kruntime.startOperation();
            this.kruntime.executeQueuedActions();
            TimerInstance timer = this.timers.remove(timerId);
            if (timer != null) {
                this.timerService.removeJob(timer.getJobHandle());
            }
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public void dispose() {
        if (this.timerService instanceof RegisteredTimerServiceDelegate) {
            return;
        }
        Iterator<TimerInstance> it = this.timers.values().iterator();
        while (it.hasNext()) {
            TimerInstance timer = it.next();
            this.timerService.removeJob(timer.getJobHandle());
            it.remove();
        }
        this.timerService.shutdown();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Collection<TimerInstance> getTimers() {
        return this.timers.values();
    }

    public Map<Long, TimerInstance> getTimerMap() {
        return this.timers;
    }

    public long internalGetTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public static class OverdueTrigger
    implements Trigger {
        private static final long serialVersionUID = -2368476147776308013L;
        public static final long OVERDUE_DELAY = Long.parseLong(System.getProperty("jbpm.overdue.timer.delay", "2000"));
        private Trigger orig;
        private InternalKnowledgeRuntime kruntime;

        public OverdueTrigger(Trigger orig, InternalKnowledgeRuntime kruntime) {
            this.orig = orig;
            this.kruntime = kruntime;
        }

        public Date hasNextFireTime() {
            long now;
            Date date = this.orig.hasNextFireTime();
            if (date == null) {
                return null;
            }
            long then = date.getTime();
            if (then < (now = this.kruntime.getSessionClock().getCurrentTime())) {
                return new Date(now + OVERDUE_DELAY);
            }
            return this.orig.hasNextFireTime();
        }

        public Date nextFireTime() {
            return this.orig.nextFireTime();
        }
    }

    public static class StartProcessJobContext
    extends ProcessJobContext {
        private static final long serialVersionUID = -5219141659893424294L;
        private String processId;
        private Map<String, Object> paramaeters;

        public StartProcessJobContext(TimerInstance timer, Trigger trigger, String processId, Map<String, Object> params, InternalKnowledgeRuntime kruntime) {
            super(timer, trigger, null, kruntime);
            this.processId = processId;
            this.paramaeters = params;
        }

        public String getProcessId() {
            return this.processId;
        }

        public void setProcessId(String processId) {
            this.processId = processId;
        }

        public Map<String, Object> getParamaeters() {
            return this.paramaeters;
        }

        public void setParamaeters(Map<String, Object> paramaeters) {
            this.paramaeters = paramaeters;
        }
    }

    public static class ProcessJobContext
    implements JobContext {
        private static final long serialVersionUID = 476843895176221627L;
        private Long processInstanceId;
        private transient InternalKnowledgeRuntime kruntime;
        private TimerInstance timer;
        private Trigger trigger;
        private JobHandle jobHandle;
        private Long sessionId;

        public ProcessJobContext(TimerInstance timer, Trigger trigger, Long processInstanceId, InternalKnowledgeRuntime kruntime) {
            this.timer = timer;
            this.trigger = trigger;
            this.processInstanceId = processInstanceId;
            this.kruntime = kruntime;
            this.sessionId = timer.getSessionId();
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public InternalKnowledgeRuntime getKnowledgeRuntime() {
            return this.kruntime;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public TimerInstance getTimer() {
            return this.timer;
        }

        public Long getSessionId() {
            return this.sessionId;
        }

        public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
            this.kruntime = kruntime;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.kruntime instanceof InternalWorkingMemory ? (InternalWorkingMemory)this.kruntime : null;
        }
    }

    public static class StartProcessJob
    implements Job,
    Serializable {
        private static final long serialVersionUID = 1039445333595469160L;

        public void execute(JobContext c) {
            StartProcessJobContext ctx = (StartProcessJobContext)c;
            InternalKnowledgeRuntime kruntime = ctx.getKnowledgeRuntime();
            try {
                ctx.getTimer().setLastTriggered(new Date(ctx.getKnowledgeRuntime().getSessionClock().getCurrentTime()));
                if (ctx.getTrigger().hasNextFireTime() == null) {
                    ctx.getTimer().setPeriod(0L);
                }
                ((ProcessRuntimeImpl)kruntime.getProcessRuntime()).startProcess(ctx.getProcessId(), ctx.getParamaeters(), "timer");
                TimerManager tm = ((InternalProcessRuntime)ctx.getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
                if (ctx.getTimer().getPeriod() == 0L) {
                    tm.getTimerMap().remove(ctx.getTimer().getId());
                    tm.getTimerService().removeJob(ctx.getJobHandle());
                }
            }
            catch (Throwable e) {
                logger.error("Error when executing start process " + ctx.getProcessId() + " timer job", e);
            }
        }
    }

    public static class ProcessJob
    implements Job,
    Serializable {
        private static final long serialVersionUID = 6004839244692770390L;

        public void execute(JobContext c) {
            block5: {
                ProcessJobContext ctx = (ProcessJobContext)c;
                Long processInstanceId = ctx.getProcessInstanceId();
                InternalKnowledgeRuntime kruntime = ctx.getKnowledgeRuntime();
                try {
                    if (processInstanceId == null) {
                        throw new IllegalArgumentException("Could not find process instance for timer ");
                    }
                    ctx.getTimer().setLastTriggered(new Date(ctx.getKnowledgeRuntime().getSessionClock().getCurrentTime()));
                    if (ctx.getTrigger().hasNextFireTime() == null) {
                        ctx.getTimer().setPeriod(0L);
                    }
                    ((InternalProcessRuntime)kruntime.getProcessRuntime()).getSignalManager().signalEvent(processInstanceId, "timerTriggered", ctx.getTimer());
                    TimerManager tm = ((InternalProcessRuntime)ctx.getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
                    if (ctx.getTimer().getPeriod() == 0L) {
                        tm.getTimerMap().remove(ctx.getTimer().getId());
                        tm.getTimerService().removeJob(ctx.getJobHandle());
                    }
                }
                catch (Throwable e) {
                    logger.error("Error when executing timer job", e);
                    WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)kruntime.getProcessInstance(processInstanceId.longValue());
                    if (processInstance == null || ctx.getTimer().getPeriod() != 0L) break block5;
                    processInstance.setState(3);
                }
            }
        }
    }

    public static class ProcessTimerInputMarshaller
    implements TimersInputMarshaller {
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            JBPMMessages.ProcessTimer _ptimer = (JBPMMessages.ProcessTimer)_timer.getExtension(JBPMMessages.procTimer);
            TimerService ts = inCtx.wm.getTimerService();
            long processInstanceId = _ptimer.getTimer().getProcessInstanceId();
            Trigger trigger = ProtobufInputMarshaller.readTrigger((MarshallerReaderContext)inCtx, (ProtobufMessages.Trigger)_ptimer.getTrigger());
            TimerInstance timerInstance = ProtobufProcessMarshaller.readTimer(inCtx, _ptimer.getTimer());
            TimerManager tm = ((InternalProcessRuntime)inCtx.wm.getProcessRuntime()).getTimerManager();
            if (!tm.getTimerMap().containsKey(timerInstance.getId())) {
                long now;
                long then;
                ProcessJobContext pctx = new ProcessJobContext(timerInstance, trigger, processInstanceId, inCtx.wm.getKnowledgeRuntime());
                Date date = trigger.hasNextFireTime();
                if (date != null && (then = date.getTime()) < (now = pctx.getKnowledgeRuntime().getSessionClock().getCurrentTime())) {
                    trigger = new OverdueTrigger(trigger, pctx.getKnowledgeRuntime());
                }
                JobHandle jobHandle = ts.scheduleJob(processJob, (JobContext)pctx, trigger);
                timerInstance.setJobHandle(jobHandle);
                pctx.setJobHandle(jobHandle);
                tm.getTimerMap().put(timerInstance.getId(), timerInstance);
            }
        }
    }

    public static class ProcessTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            if (jobCtx instanceof StartProcessJobContext) {
                return null;
            }
            ProcessJobContext pctx = (ProcessJobContext)jobCtx;
            return ((ProtobufMessages.Timers.Timer.Builder)ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.PROCESS).setExtension(JBPMMessages.procTimer, (Object)JBPMMessages.ProcessTimer.newBuilder().setTimer(ProtobufProcessMarshaller.writeTimer(outputCtx, pctx.getTimer())).setTrigger(ProtobufOutputMarshaller.writeTrigger((Trigger)pctx.getTrigger(), (MarshallerWriteContext)outputCtx)).build())).build();
        }
    }
}

