/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Id;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.drools.core.util.StringUtils;
import org.jbpm.services.task.impl.model.AttachmentImpl;
import org.jbpm.services.task.impl.model.CommentImpl;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.DeadlineImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.persistence.TaskQueryManager;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPATaskPersistenceContext
implements TaskPersistenceContext {
    public static final Logger logger = LoggerFactory.getLogger(JPATaskPersistenceContext.class);
    private static TaskQueryManager querymanager = TaskQueryManager.get();
    protected EntityManager em;
    protected final boolean isJTA;
    protected final boolean pessimisticLocking;

    public JPATaskPersistenceContext(EntityManager em) {
        this(em, true, false);
    }

    public JPATaskPersistenceContext(EntityManager em, boolean isJTA) {
        this(em, isJTA, false);
    }

    public JPATaskPersistenceContext(EntityManager em, boolean isJTA, boolean locking) {
        this.em = em;
        this.isJTA = isJTA;
        this.pessimisticLocking = locking;
        logger.debug("TaskPersistenceManager configured with em {}, isJTA {}, pessimistic locking {}", new Object[]{em, isJTA, locking});
    }

    public Task findTask(Long taskId) {
        this.check();
        Task task = null;
        if (this.pessimisticLocking) {
            task = (Task)this.em.find(TaskImpl.class, (Object)taskId, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        task = (Task)this.em.find(TaskImpl.class, (Object)taskId);
        return task;
    }

    public Task persistTask(Task task) {
        this.check();
        this.em.persist((Object)task);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (Task)this.em.find(TaskImpl.class, (Object)task.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return task;
    }

    public Task updateTask(Task task) {
        this.check();
        return (Task)this.em.merge((Object)task);
    }

    public Task removeTask(Task task) {
        this.check();
        this.em.remove((Object)task);
        return task;
    }

    public Group findGroup(String groupId) {
        this.check();
        if (this.pessimisticLocking) {
            return (Group)this.em.find(GroupImpl.class, (Object)groupId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (Group)this.em.find(GroupImpl.class, (Object)groupId);
    }

    public Group persistGroup(Group group) {
        this.check();
        try {
            this.em.persist((Object)group);
            if (this.pessimisticLocking) {
                this.em.flush();
                return (Group)this.em.find(GroupImpl.class, (Object)group.getId(), LockModeType.PESSIMISTIC_WRITE);
            }
        }
        catch (EntityExistsException e) {
            throw new RuntimeException("Group already exists with " + group + " id, please check that there is no group and user with same id");
        }
        return group;
    }

    public Group updateGroup(Group group) {
        this.check();
        return (Group)this.em.merge((Object)group);
    }

    public Group removeGroup(Group group) {
        this.check();
        this.em.remove((Object)group);
        return group;
    }

    public User findUser(String userId) {
        this.check();
        if (this.pessimisticLocking) {
            return (User)this.em.find(UserImpl.class, (Object)userId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (User)this.em.find(UserImpl.class, (Object)userId);
    }

    public User persistUser(User user) {
        this.check();
        try {
            this.em.persist((Object)user);
            if (this.pessimisticLocking) {
                this.em.flush();
                return (User)this.em.find(UserImpl.class, (Object)user.getId(), LockModeType.PESSIMISTIC_WRITE);
            }
        }
        catch (EntityExistsException e) {
            throw new RuntimeException("User already exists with " + user + " id, please check that there is no group and user with same id");
        }
        return user;
    }

    public User updateUser(User user) {
        this.check();
        return (User)this.em.merge((Object)user);
    }

    public User removeUser(User user) {
        this.check();
        this.em.remove((Object)user);
        return user;
    }

    public OrganizationalEntity findOrgEntity(String orgEntityId) {
        this.check();
        if (this.pessimisticLocking) {
            return (OrganizationalEntity)this.em.find(OrganizationalEntityImpl.class, (Object)orgEntityId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (OrganizationalEntity)this.em.find(OrganizationalEntityImpl.class, (Object)orgEntityId);
    }

    public OrganizationalEntity persistOrgEntity(OrganizationalEntity orgEntity) {
        this.check();
        if (!StringUtils.isEmpty((CharSequence)orgEntity.getId())) {
            try {
                this.em.persist((Object)orgEntity);
                if (this.pessimisticLocking) {
                    this.em.flush();
                    return (OrganizationalEntity)this.em.find(OrganizationalEntityImpl.class, (Object)orgEntity.getId(), LockModeType.PESSIMISTIC_WRITE);
                }
            }
            catch (EntityExistsException e) {
                throw new RuntimeException("Organizational entity already exists with " + orgEntity + " id, please check that there is no group and user with same id");
            }
        }
        return orgEntity;
    }

    public OrganizationalEntity updateOrgEntity(OrganizationalEntity orgEntity) {
        this.check();
        return (OrganizationalEntity)this.em.merge((Object)orgEntity);
    }

    public OrganizationalEntity removeOrgEntity(OrganizationalEntity orgEntity) {
        this.check();
        this.em.remove((Object)orgEntity);
        return orgEntity;
    }

    public Content findContent(Long contentId) {
        this.check();
        if (this.pessimisticLocking) {
            return (Content)this.em.find(ContentImpl.class, (Object)contentId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (Content)this.em.find(ContentImpl.class, (Object)contentId);
    }

    public Content persistContent(Content content) {
        this.check();
        this.em.persist((Object)content);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (Content)this.em.find(ContentImpl.class, (Object)content.getId(), LockModeType.PESSIMISTIC_WRITE);
        }
        return content;
    }

    public Content updateContent(Content content) {
        this.check();
        return (Content)this.em.merge((Object)content);
    }

    public Content removeContent(Content content) {
        this.check();
        this.em.remove((Object)content);
        return content;
    }

    public Attachment findAttachment(Long attachmentId) {
        this.check();
        if (this.pessimisticLocking) {
            return (Attachment)this.em.find(AttachmentImpl.class, (Object)attachmentId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (Attachment)this.em.find(AttachmentImpl.class, (Object)attachmentId);
    }

    public Attachment persistAttachment(Attachment attachment) {
        this.check();
        this.em.persist((Object)attachment);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (Attachment)this.em.find(AttachmentImpl.class, (Object)attachment.getId(), LockModeType.PESSIMISTIC_WRITE);
        }
        return attachment;
    }

    public Attachment updateAttachment(Attachment attachment) {
        this.check();
        return (Attachment)this.em.merge((Object)attachment);
    }

    public Attachment removeAttachment(Attachment attachment) {
        this.check();
        this.em.remove((Object)attachment);
        return attachment;
    }

    public Comment findComment(Long commentId) {
        this.check();
        if (this.pessimisticLocking) {
            return (Comment)this.em.find(CommentImpl.class, (Object)commentId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (Comment)this.em.find(CommentImpl.class, (Object)commentId);
    }

    public Comment persistComment(Comment comment) {
        this.check();
        this.em.persist((Object)comment);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (Comment)this.em.find(CommentImpl.class, (Object)comment.getId(), LockModeType.PESSIMISTIC_WRITE);
        }
        return comment;
    }

    public Comment updateComment(Comment comment) {
        this.check();
        return (Comment)this.em.merge((Object)comment);
    }

    public Comment removeComment(Comment comment) {
        this.check();
        this.em.remove((Object)comment);
        return comment;
    }

    public Deadline findDeadline(Long deadlineId) {
        this.check();
        if (this.pessimisticLocking) {
            return (Deadline)this.em.find(DeadlineImpl.class, (Object)deadlineId, LockModeType.PESSIMISTIC_WRITE);
        }
        return (Deadline)this.em.find(DeadlineImpl.class, (Object)deadlineId);
    }

    public Deadline persistDeadline(Deadline deadline) {
        this.check();
        this.em.persist((Object)deadline);
        if (this.pessimisticLocking) {
            this.em.flush();
            return (Deadline)this.em.find(DeadlineImpl.class, (Object)deadline.getId(), LockModeType.PESSIMISTIC_WRITE);
        }
        return deadline;
    }

    public Deadline updateDeadline(Deadline deadline) {
        this.check();
        return (Deadline)this.em.merge((Object)deadline);
    }

    public Deadline removeDeadline(Deadline deadline) {
        this.check();
        this.em.remove((Object)deadline);
        return deadline;
    }

    public <T> T queryWithParametersInTransaction(String queryName, Map<String, Object> params, Class<T> clazz) {
        this.check();
        Query query = this.getQueryByName(queryName, params);
        return this.queryStringWithParameters(params, false, LockModeType.NONE, clazz, query);
    }

    public <T> T queryWithParametersInTransaction(String queryName, boolean singleResult, Map<String, Object> params, Class<T> clazz) {
        this.check();
        Query query = this.getQueryByName(queryName, params);
        return this.queryStringWithParameters(params, singleResult, LockModeType.NONE, clazz, query);
    }

    public <T> T queryAndLockWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult, Class<T> clazz) {
        this.check();
        Query query = this.getQueryByName(queryName, params);
        return this.queryStringWithParameters(params, singleResult, LockModeType.NONE, clazz, query);
    }

    public <T> T queryInTransaction(String queryName, Class<T> clazz) {
        this.check();
        Query query = this.em.createNamedQuery(queryName);
        return (T)query.getResultList();
    }

    public <T> T queryStringInTransaction(String queryString, Class<T> clazz) {
        this.check();
        Query query = this.em.createQuery(queryString);
        return (T)query.getResultList();
    }

    public <T> T queryStringWithParametersInTransaction(String queryString, Map<String, Object> params, Class<T> clazz) {
        this.check();
        String newQueryString = TaskQueryManager.adaptQueryString(new StringBuilder(queryString), params);
        if (newQueryString != null) {
            queryString = newQueryString;
        }
        logger.debug("QUERY:\n {}", (Object)queryString);
        if (logger.isDebugEnabled()) {
            StringBuilder paramsStr = new StringBuilder("PARAMS:");
            TreeMap<String, Object> orderedParams = new TreeMap<String, Object>(params);
            for (Map.Entry entry : orderedParams.entrySet()) {
                paramsStr.append("\n " + (String)entry.getKey() + " : '" + entry.getValue() + "'");
            }
            logger.debug(paramsStr.toString());
        }
        Query query = this.em.createQuery(queryString);
        return this.queryStringWithParameters(params, false, LockModeType.NONE, clazz, query);
    }

    public <T> T queryStringWithParametersInTransaction(String queryString, boolean singleResult, Map<String, Object> params, Class<T> clazz) {
        this.check();
        Query query = this.em.createQuery(queryString);
        return this.queryStringWithParameters(params, singleResult, LockModeType.NONE, clazz, query);
    }

    public <T> T queryAndLockStringWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult, Class<T> clazz) {
        this.check();
        Query query = this.getQueryByName(queryName, params);
        return this.queryStringWithParameters(params, singleResult, LockModeType.PESSIMISTIC_WRITE, clazz, query);
    }

    public int executeUpdateString(String updateString) {
        this.check();
        Query query = this.em.createQuery(updateString);
        return query.executeUpdate();
    }

    public HashMap<String, Object> addParametersToMap(Object ... parameterValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (parameterValues.length % 2 != 0) {
            throw new RuntimeException("Expected an even number of parameters, not " + parameterValues.length);
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            String parameterName = null;
            if (!(parameterValues[i] instanceof String)) {
                throw new RuntimeException("Expected a String as the parameter name, not a " + parameterValues[i].getClass().getSimpleName());
            }
            parameterName = (String)parameterValues[i];
            parameters.put(parameterName, parameterValues[++i]);
        }
        return parameters;
    }

    public <T> T persist(T object) {
        this.check();
        this.em.persist(object);
        if (this.pessimisticLocking) {
            this.em.flush();
            Object primaryKey = this.getFieldValueWithAnnotation(object, Id.class);
            return (T)this.em.find(object.getClass(), primaryKey, LockModeType.PESSIMISTIC_WRITE);
        }
        return object;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.check();
        if (this.pessimisticLocking) {
            return (T)this.em.find(entityClass, primaryKey, LockModeType.PESSIMISTIC_WRITE);
        }
        return (T)this.em.find(entityClass, primaryKey);
    }

    public <T> T remove(T entity) {
        this.check();
        this.em.remove(entity);
        return entity;
    }

    public <T> T merge(T entity) {
        this.check();
        return (T)this.em.merge(entity);
    }

    private <T> T queryStringWithParameters(Map<String, Object> params, boolean singleResult, LockModeType lockMode, Class<T> clazz, Query query) {
        if (lockMode != null) {
            query.setLockMode(lockMode);
        }
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> paramEntry : params.entrySet()) {
                String name = paramEntry.getKey();
                if ("firstResult".equals(name)) {
                    query.setFirstResult(((Integer)paramEntry.getValue()).intValue());
                    continue;
                }
                if ("maxResults".equals(name)) {
                    if ((Integer)paramEntry.getValue() <= -1) continue;
                    query.setMaxResults(((Integer)paramEntry.getValue()).intValue());
                    continue;
                }
                if ("flushMode".equals(name)) {
                    query.setFlushMode(FlushModeType.valueOf((String)((String)paramEntry.getValue())));
                    continue;
                }
                if ("orderType".equals(name) || "orderby".equals(name) || "filter".equals(name)) continue;
                query.setParameter(name, params.get(name));
            }
        }
        if (singleResult) {
            List results = query.getResultList();
            return results.isEmpty() ? null : (T)results.get(0);
        }
        return (T)query.getResultList();
    }

    public boolean isOpen() {
        if (this.em == null) {
            return false;
        }
        return this.em.isOpen();
    }

    public void joinTransaction() {
        if (this.em == null) {
            return;
        }
        if (this.isJTA) {
            this.em.joinTransaction();
        }
    }

    public void close() {
        this.check();
        this.em.close();
    }

    protected void check() {
        if (this.em == null || !this.em.isOpen()) {
            throw new IllegalStateException("Entity manager is null or is closed, exiting...");
        }
    }

    protected Query getQueryByName(String queryName, Map<String, Object> params) {
        String queryStr = querymanager.getQuery(queryName, params);
        Query query = null;
        query = queryStr != null ? this.em.createQuery(queryStr) : this.em.createNamedQuery(queryName);
        return query;
    }

    private Object getFieldValueWithAnnotation(Object object, Class<? extends Annotation> annotation) {
        try {
            Field[] fields;
            for (Field f : fields = object.getClass().getDeclaredFields()) {
                if (!f.isAnnotationPresent(annotation)) continue;
                f.setAccessible(true);
                return f.get(object);
            }
        }
        catch (Exception e) {
            logger.error("Unable to find primary key of class {} sure to {}", object.getClass(), (Object)e.getMessage());
        }
        return null;
    }
}

