/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.command.runtime.process.SetProcessInstanceVariablesCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItemManager;
import org.jbpm.kie.services.impl.CommonUtils;
import org.jbpm.kie.services.impl.VariablesAware;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.WorkItemNotFoundException;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessServiceImpl
implements ProcessService,
VariablesAware {
    private static final Logger logger = LoggerFactory.getLogger(ProcessServiceImpl.class);
    private DeploymentService deploymentService;
    private RuntimeDataService dataService;

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setDataService(RuntimeDataService dataService) {
        this.dataService = dataService;
    }

    public Long startProcess(String deploymentId, String processId) {
        return this.startProcess(deploymentId, processId, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long startProcess(String deploymentId, String processId, Map<String, Object> params) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        if (!deployedUnit.isActive()) {
            throw new DeploymentNotFoundException("Deployments " + deploymentId + " is not active");
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        ProcessInstance pi = null;
        try {
            pi = ksession.startProcess(processId, params);
            Long l = pi.getId();
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortProcessInstance(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.abortProcessInstance(processInstanceId.longValue());
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void abortProcessInstances(List<Long> processInstanceIds) {
        for (long processInstanceId : processInstanceIds) {
            this.abortProcessInstance(processInstanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalProcessInstance(Long processInstanceId, String signalName, Object event) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        event = this.process(event, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.signalEvent(signalName, event, processInstanceId.longValue());
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    public void signalProcessInstances(List<Long> processInstanceIds, String signalName, Object event) {
        for (Long processInstanceId : processInstanceIds) {
            this.signalProcessInstance(processInstanceId, signalName, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInstance getProcessInstance(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            return null;
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId.longValue());
            return processInstance;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessVariable(Long processInstanceId, String variableId, Object value) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        value = this.process(value, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstanceId.longValue(), Collections.singletonMap(variableId, value)));
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessVariables(Long processInstanceId, Map<String, Object> variables) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        variables = this.process(variables, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstanceId.longValue(), variables));
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProcessInstanceVariable(Long processInstanceId, String variableName) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            Object variable;
            WorkflowProcessInstance pi = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId.longValue());
            if (pi == null) {
                throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
            }
            Object object = variable = pi.getVariable(variableName);
            return object;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProcessInstanceVariables(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)ksession.getProcessInstance(processInstanceId.longValue());
            Map map = pi.getVariables();
            return map;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAvailableSignals(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId.longValue());
            ArrayList<String> activeSignals = new ArrayList<String>();
            if (processInstance != null) {
                ((ProcessInstanceImpl)processInstance).setProcess(ksession.getKieBase().getProcess(processInstance.getProcessId()));
                Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
                activeSignals.addAll(this.collectActiveSignals(activeNodes));
            }
            ArrayList<String> arrayList = activeSignals;
            return arrayList;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeWorkItem(Long id, Map<String, Object> results) {
        NodeInstanceDesc nodeDesc = this.dataService.getNodeInstanceForWorkItem(id);
        if (nodeDesc == null) {
            throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(nodeDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + nodeDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        results = this.process(results, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)nodeDesc.getProcessInstanceId()));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.getWorkItemManager().completeWorkItem(id.longValue(), results);
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortWorkItem(Long id) {
        NodeInstanceDesc nodeDesc = this.dataService.getNodeInstanceForWorkItem(id);
        if (nodeDesc == null) {
            throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(nodeDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + nodeDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)nodeDesc.getProcessInstanceId()));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.getWorkItemManager().abortWorkItem(id.longValue());
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItem getWorkItem(Long id) {
        NodeInstanceDesc nodeDesc = this.dataService.getNodeInstanceForWorkItem(id);
        if (nodeDesc == null) {
            throw new WorkItemNotFoundException("Work item with id " + id + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(nodeDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + nodeDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)nodeDesc.getProcessInstanceId()));
        KieSession ksession = engine.getKieSession();
        try {
            org.drools.core.process.instance.WorkItem workItem = ((WorkItemManager)ksession.getWorkItemManager()).getWorkItem(id.longValue());
            return workItem;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkItem> getWorkItemByProcessInstance(Long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
        if (piDesc == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + processInstanceId + " was not found");
        }
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId());
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + piDesc.getDeploymentId());
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ArrayList<WorkItem> workItems = new ArrayList<WorkItem>();
            Collection nodes = this.dataService.getProcessInstanceHistoryActive(processInstanceId.longValue(), null);
            for (NodeInstanceDesc node : nodes) {
                if (node.getWorkItemId() == null) continue;
                workItems.add((WorkItem)((WorkItemManager)ksession.getWorkItemManager()).getWorkItem(node.getWorkItemId().longValue()));
            }
            ArrayList<WorkItem> arrayList = workItems;
            return arrayList;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String deploymentId, Command<T> command) {
        Long processInstanceId = CommonUtils.getProcessInstanceId(command);
        logger.debug("Executing command {} with process instance id {} as contextual data", command, (Object)processInstanceId);
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        this.disallowWhenNotActive(deployedUnit, command);
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            Object object = ksession.execute(command);
            return (T)object;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String deploymentId, Context<?> context, Command<T> command) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        this.disallowWhenNotActive(deployedUnit, command);
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        RuntimeEngine engine = manager.getRuntimeEngine(context);
        KieSession ksession = engine.getKieSession();
        try {
            Object object = ksession.execute(command);
            return (T)object;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    protected void disallowWhenNotActive(DeployedUnit deployedUnit, Command<?> cmd) {
        if (!deployedUnit.isActive() && cmd instanceof StartProcessCommand) {
            throw new DeploymentNotFoundException("Deployments " + deployedUnit.getDeploymentUnit().getIdentifier() + " is not active");
        }
    }

    protected Collection<String> collectActiveSignals(Collection<NodeInstance> activeNodes) {
        ArrayList<String> activeNodesComposite = new ArrayList<String>();
        for (NodeInstance nodeInstance : activeNodes) {
            String type;
            if (nodeInstance instanceof EventNodeInstance && (type = ((EventNodeInstance)nodeInstance).getEventNode().getType()) != null && !type.startsWith("Message-")) {
                activeNodesComposite.add(type);
            }
            if (!(nodeInstance instanceof CompositeNodeInstance)) continue;
            Collection currentNodeInstances = ((CompositeNodeInstance)nodeInstance).getNodeInstances();
            activeNodesComposite.addAll(this.collectActiveSignals(currentNodeInstances));
        }
        return activeNodesComposite;
    }

    @Override
    public <T> T process(T variables, ClassLoader cl) {
        return variables;
    }

    protected void disposeRuntimeEngine(RuntimeManager manager, RuntimeEngine engine) {
        manager.disposeRuntimeEngine(engine);
    }
}

