/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.ImportHandler;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceExtensionSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessGetImportHandler
extends ImportHandler {
    private BPMN2DataServiceExtensionSemanticModule module;
    private ProcessDescriptionRepository repository;

    public ProcessGetImportHandler(BPMN2DataServiceExtensionSemanticModule module) {
        this.module = module;
        this.repository = module.getRepo();
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        super.start(uri, localName, attrs, parser);
        String name = attrs.getValue("name");
        String type = attrs.getValue("importType");
        String location = attrs.getValue("location");
        String namespace = attrs.getValue("namespace");
        if (type == null || location == null || namespace == null) {
            String mainProcessId = this.module.getRepoHelper().getProcess().getId();
            ProcessDescRepoHelper repoHelper = this.repository.getProcessDesc(mainProcessId);
            if (name.contains(".")) {
                repoHelper.getReferencedClasses().add(name);
            } else {
                repoHelper.getUnqualifiedClasses().add(name);
            }
        }
        return null;
    }
}

