/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.ws;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRemoteWsAuthenticator
extends Authenticator {
    protected static final Logger logger = LoggerFactory.getLogger(KieRemoteWsAuthenticator.class);
    private static ThreadLocal<PasswordAuthentication> threadLocalPasswordAuthentication = new ThreadLocal();
    private static AtomicBoolean authenticatorSet = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAndPassword(String userName, String password) {
        PasswordAuthentication pwdAuth;
        if (!authenticatorSet.get()) {
            AtomicBoolean atomicBoolean = authenticatorSet;
            synchronized (atomicBoolean) {
                if (authenticatorSet.compareAndSet(false, true)) {
                    Authenticator.setDefault(this);
                }
            }
        }
        if ((pwdAuth = threadLocalPasswordAuthentication.get()) != null) {
            logger.debug("Replacing password authentication for user '{}' with new authentication for user '{}'", (Object)pwdAuth.getUserName(), (Object)userName);
        }
        pwdAuth = new PasswordAuthentication(userName, password.toCharArray());
        threadLocalPasswordAuthentication.set(pwdAuth);
    }

    public void clearUserAndPassword() {
        threadLocalPasswordAuthentication.set(null);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return threadLocalPasswordAuthentication.get();
    }
}

