/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.kie.api.command.Command;
import org.kie.remote.client.api.exception.MissingRequiredInfoException;
import org.kie.remote.client.api.exception.RemoteApiException;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.jaxb.gen.TaskCommand;
import org.kie.services.client.api.command.AbstractRemoteCommandObject;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;

public class InternalJmsCommandHelper {
    public static <T> T internalExecuteJmsCommand(Command command, ConnectionFactory factory, Queue sendQueue, Queue responseQueue, SerializationProvider serializationProvider) {
        return InternalJmsCommandHelper.internalExecuteJmsCommand(command, null, null, null, null, null, null, null, factory, sendQueue, responseQueue, serializationProvider, null, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T internalExecuteJmsCommand(Command command, String connUser, String connPassword, String userName, String password, String deploymentId, Long processInstanceId, List<String> rorrelationKeyProperties, ConnectionFactory factory, Queue sendQueue, Queue responseQueue, SerializationProvider serializationProvider, Set<Class<?>> extraJaxbClasses, int serializationType, Long timeoutInMillisecs) {
        List<JaxbCommandResponse<?>> responses;
        JaxbCommandsRequest req = AbstractRemoteCommandObject.prepareCommandRequest(command, userName, deploymentId, processInstanceId, rorrelationKeyProperties);
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            TextMessage textMsg;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = password != null ? factory.createConnection(connUser, connPassword) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to setup a JMS connection", jmse);
            }
            try {
                boolean isTaskCommand;
                String xmlStr = serializationProvider.serialize((Object)req);
                textMsg = session.createTextMessage(xmlStr);
                textMsg.setJMSCorrelationID(corrId);
                textMsg.setIntProperty("serialization", serializationType);
                if (extraJaxbClasses != null && !extraJaxbClasses.isEmpty()) {
                    if (AbstractRemoteCommandObject.emptyDeploymentId(deploymentId)) {
                        throw new MissingRequiredInfoException("Deserialization of parameter classes requires a deployment id, which has not been configured.");
                    }
                    textMsg.setStringProperty("deploymentId", deploymentId);
                }
                if (isTaskCommand = command instanceof TaskCommand) {
                    if (userName == null) {
                        throw new RemoteCommunicationException("A user name is required when sending task operation requests via JMS");
                    }
                    if (password == null) {
                        throw new RemoteCommunicationException("A password is required when sending task operation requests via JMS");
                    }
                    textMsg.setStringProperty("username", userName);
                    textMsg.setStringProperty("password", password);
                }
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to create and fill a JMS message.", jmse);
            }
            catch (SerializationException se) {
                throw new RemoteCommunicationException("Unable to deserialze JMS message.", se.getCause());
            }
            try {
                producer.send((Message)textMsg);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to send a JMS message.", jmse);
            }
            try {
                response = timeoutInMillisecs != null ? consumer.receive(timeoutInMillisecs.longValue()) : consumer.receive();
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to receive or retrieve the JMS response.", jmse);
            }
            if (response == null) {
                AbstractRemoteCommandObject.logger.warn("Response is empty");
                T jmse = null;
                return jmse;
            }
            assert (response != null) : "Response is empty.";
            try {
                String xmlStr = ((TextMessage)response).getText();
                cmdResponse = (JaxbCommandsResponse)serializationProvider.deserialize(xmlStr);
            }
            catch (JMSException jmse) {
                throw new RemoteCommunicationException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", jmse);
            }
            catch (SerializationException se) {
                throw new RemoteCommunicationException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", se.getCause());
            }
            assert (cmdResponse != null) : "Jaxb Cmd Response was null!";
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jmse) {
                    AbstractRemoteCommandObject.logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
        String version = cmdResponse.getVersion();
        if (version == null) {
            version = "pre-6.0.3";
        }
        if (!version.equals("6.3.0.1")) {
            AbstractRemoteCommandObject.logger.info("Response received from server version [{}] while client is version [{}]! This may cause problems.", (Object)version, (Object)"6.3.0.1");
        }
        if ((responses = cmdResponse.getResponses()).size() > 0) {
            JaxbCommandResponse<?> response = responses.get(0);
            if (response instanceof JaxbExceptionResponse) {
                JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)response;
                throw new RemoteApiException(exceptionResponse.getMessage(), exceptionResponse.getStackTrace());
            }
            return (T)response.getResult();
        }
        assert (responses.size() == 0) : "There should only be 1 response, not " + responses.size() + ", returned by a command!";
        return null;
    }
}

