/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.beans.Introspector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;

public class ClassFieldReader
implements Externalizable,
InternalReadAccessor {
    private static final long serialVersionUID = 510L;
    private String className;
    private String fieldName;
    private transient InternalReadAccessor reader;

    public ClassFieldReader() {
    }

    public ClassFieldReader(String className, String fieldName) {
        this.className = className;
        this.fieldName = Introspector.decapitalize(fieldName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.fieldName);
    }

    @Override
    public void readExternal(ObjectInput is) throws ClassNotFoundException, IOException {
        this.className = (String)is.readObject();
        this.fieldName = (String)is.readObject();
    }

    public void setReadAccessor(InternalReadAccessor reader) {
        this.reader = reader;
    }

    @Override
    public int getIndex() {
        return this.reader.getIndex();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean hasReadAccessor() {
        return this.reader != null;
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getValue(workingMemory, object);
    }

    @Override
    public ValueType getValueType() {
        return this.reader.getValueType();
    }

    @Override
    public Class<?> getExtractToClass() {
        return this.reader != null ? this.reader.getExtractToClass() : null;
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.reader.getExtractToClass());
    }

    public String toString() {
        return "[ClassFieldExtractor class=" + this.className + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassFieldReader)) {
            return false;
        }
        ClassFieldReader other = (ClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    @Override
    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getBooleanValue(workingMemory, object);
    }

    @Override
    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getByteValue(workingMemory, object);
    }

    @Override
    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getCharValue(workingMemory, object);
    }

    @Override
    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getDoubleValue(workingMemory, object);
    }

    @Override
    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getFloatValue(workingMemory, object);
    }

    @Override
    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getIntValue(workingMemory, object);
    }

    @Override
    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getLongValue(workingMemory, object);
    }

    @Override
    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getShortValue(workingMemory, object);
    }

    @Override
    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.isNullValue(workingMemory, object);
    }

    @Override
    public Method getNativeReadMethod() {
        return this.reader.getNativeReadMethod();
    }

    @Override
    public String getNativeReadMethodName() {
        return this.reader.getNativeReadMethod().getName();
    }

    @Override
    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getHashCode(workingMemory, object);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return "this".equals(this.fieldName);
    }

    @Override
    public boolean getBooleanValue(Object object) {
        return this.reader.getBooleanValue(object);
    }

    @Override
    public byte getByteValue(Object object) {
        return this.reader.getByteValue(object);
    }

    @Override
    public char getCharValue(Object object) {
        return this.reader.getCharValue(object);
    }

    @Override
    public double getDoubleValue(Object object) {
        return this.reader.getDoubleValue(object);
    }

    @Override
    public float getFloatValue(Object object) {
        return this.reader.getFloatValue(object);
    }

    @Override
    public int getHashCode(Object object) {
        return this.reader.getHashCode(object);
    }

    @Override
    public int getIntValue(Object object) {
        return this.reader.getIntValue(object);
    }

    @Override
    public long getLongValue(Object object) {
        return this.reader.getLongValue(object);
    }

    @Override
    public short getShortValue(Object object) {
        return this.reader.getShortValue(object);
    }

    @Override
    public Object getValue(Object object) {
        return this.reader.getValue(object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.reader.isNullValue(object);
    }

    @Override
    public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getBigDecimalValue(workingMemory, object);
    }

    @Override
    public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
        return this.reader.getBigIntegerValue(workingMemory, object);
    }

    @Override
    public BigDecimal getBigDecimalValue(Object object) {
        return this.reader.getBigDecimalValue(object);
    }

    @Override
    public BigInteger getBigIntegerValue(Object object) {
        return this.reader.getBigIntegerValue(object);
    }
}

